/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.bot;

import com.google.common.base.Charsets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.LevelResource;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.leavesmc.leaves.bot.ServerBot;
import org.leavesmc.leaves.bot.agent.Actions;
import org.leavesmc.leaves.bot.agent.BotAction;

public class BotUtil {
    public static void replenishment(@NotNull ItemStack itemStack, NonNullList<ItemStack> itemStackList) {
        int count = itemStack.getMaxStackSize() / 2;
        if (itemStack.getCount() <= 8 && count > 8) {
            for (ItemStack itemStack1 : itemStackList) {
                if (itemStack1 == ItemStack.EMPTY || itemStack1 == itemStack || !ItemStack.isSameItemSameComponents(itemStack1, itemStack)) continue;
                if (itemStack1.getCount() > count) {
                    itemStack.setCount(itemStack.getCount() + count);
                    itemStack1.setCount(itemStack1.getCount() - count);
                    break;
                }
                itemStack.setCount(itemStack.getCount() + itemStack1.getCount());
                itemStack1.setCount(0);
                break;
            }
        }
    }

    public static void replaceTool(@NotNull EquipmentSlot slot, @NotNull ServerBot bot) {
        ItemStack itemStack1;
        int i;
        ItemStack itemStack = bot.getItemBySlot(slot);
        for (i = 0; i < 36; ++i) {
            itemStack1 = bot.getInventory().getItem(i);
            if (itemStack1 == ItemStack.EMPTY || itemStack1 == itemStack || itemStack1.getItem().getClass() != itemStack.getItem().getClass() || BotUtil.isDamage(itemStack1, 10)) continue;
            ItemStack itemStack2 = itemStack1.copy();
            bot.getInventory().setItem(i, itemStack);
            bot.setItemSlot(slot, itemStack2);
            return;
        }
        for (i = 0; i < 36; ++i) {
            itemStack1 = bot.getInventory().getItem(i);
            if (itemStack1 != ItemStack.EMPTY || itemStack1 == itemStack) continue;
            bot.getInventory().setItem(i, itemStack);
            bot.setItemSlot(slot, ItemStack.EMPTY);
            return;
        }
    }

    public static boolean isDamage(@NotNull ItemStack item, int minDamage) {
        return item.isDamageableItem() && item.getMaxDamage() - item.getDamageValue() <= minDamage;
    }

    @NotNull
    public static JsonObject saveBot(@NotNull ServerBot bot) {
        double pos_x = bot.getX();
        double pos_y = bot.getY();
        double pos_z = bot.getZ();
        float yaw = bot.getYRot();
        float pitch = bot.getXRot();
        String dimension = bot.getLocation().getWorld().getName();
        String skin = bot.createState.skinName;
        JsonObject fakePlayer = new JsonObject();
        fakePlayer.addProperty("pos_x", (Number)pos_x);
        fakePlayer.addProperty("pos_y", (Number)pos_y);
        fakePlayer.addProperty("pos_z", (Number)pos_z);
        fakePlayer.addProperty("yaw", (Number)Float.valueOf(yaw));
        fakePlayer.addProperty("pitch", (Number)Float.valueOf(pitch));
        fakePlayer.addProperty("dimension", dimension);
        fakePlayer.addProperty("skin", skin);
        Collection<BotAction> actions = bot.getBotActions();
        JsonArray botActions = new JsonArray();
        for (BotAction action : actions) {
            JsonObject actionObj = new JsonObject();
            actionObj.addProperty("name", action.getName());
            actionObj.addProperty("number", String.valueOf(action.getNumber()));
            actionObj.addProperty("delay", String.valueOf(action.getTickDelay()));
            botActions.add((JsonElement)actionObj);
        }
        fakePlayer.add("actions", (JsonElement)botActions);
        CompoundTag invnbt = new CompoundTag();
        invnbt.put("Inventory", bot.getInventory().save(new ListTag()));
        File file = MinecraftServer.getServer().getWorldPath(LevelResource.ROOT).resolve("fakeplayer/" + bot.getStringUUID() + ".dat").toFile();
        File parent = file.getParentFile();
        try {
            if (!parent.exists() || !parent.isDirectory()) {
                parent.mkdirs();
            }
            if (file.exists() && file.isFile()) {
                file.delete();
            }
            file.createNewFile();
            NbtIo.writeCompressed(invnbt, file.toPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fakePlayer;
    }

    public static void loadBot( @NotNull Map.Entry<String, JsonElement> entry) {
        String username = entry.getKey();
        JsonObject fakePlayer = entry.getValue().getAsJsonObject();
        double pos_x = fakePlayer.get("pos_x").getAsDouble();
        double pos_y = fakePlayer.get("pos_y").getAsDouble();
        double pos_z = fakePlayer.get("pos_z").getAsDouble();
        float yaw = fakePlayer.get("yaw").getAsFloat();
        float pitch = fakePlayer.get("pitch").getAsFloat();
        String dimension = fakePlayer.get("dimension").getAsString();
        String skin = fakePlayer.get("skin").getAsString();
        Location location = new Location(Bukkit.getWorld((String)dimension), pos_x, pos_y, pos_z, yaw, pitch);
        ServerBot.BotCreateState state = new ServerBot.BotCreateState(location, username, skin);
        ListTag inv = null;
        File file = MinecraftServer.getServer().getWorldPath(LevelResource.ROOT).resolve("fakeplayer/" + String.valueOf(BotUtil.getBotUUID(state)) + ".dat").toFile();
        if (file.exists()) {
            try {
                CompoundTag nbt = NbtIo.readCompressed(file.toPath(), NbtAccounter.unlimitedHeap());
                inv = nbt.getList("Inventory", 10);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            file.delete();
        }
        JsonArray finalActions = fakePlayer.get("actions").getAsJsonArray();
        ListTag finalInv = inv;
        state.createAsync(serverBot -> {
            if (finalInv != null) {
                serverBot.getInventory().load(finalInv);
            }
            for (JsonElement element : finalActions) {
                JsonObject actionObj = element.getAsJsonObject();
                BotAction action = Actions.getForName(actionObj.get("name").getAsString());
                if (action == null) continue;
                BotAction newAction = action.getNew((ServerPlayer)serverBot, action.getArgument().parse(0, new String[]{actionObj.get("delay").getAsString(), actionObj.get("number").getAsString()}));
                serverBot.setBotAction(newAction);
            }
        });
    }

    @NotNull
    public static UUID getBotUUID(@NotNull ServerBot.BotCreateState state) {
        return UUID.nameUUIDFromBytes(("Fakeplayer:" + state.getRealName()).getBytes(Charsets.UTF_8));
    }
}

