/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.bot;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.scheduler.CraftScheduler;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.leavesmc.leaves.LeavesConfig;
import org.leavesmc.leaves.bot.BotInventoryContainer;
import org.leavesmc.leaves.bot.BotStatsCounter;
import org.leavesmc.leaves.bot.BotUtil;
import org.leavesmc.leaves.bot.MojangAPI;
import org.leavesmc.leaves.bot.ServerBotGameMode;
import org.leavesmc.leaves.bot.agent.BotAction;
import org.leavesmc.leaves.bot.agent.actions.StopAction;
import org.leavesmc.leaves.entity.Bot;
import org.leavesmc.leaves.entity.CraftBot;
import org.leavesmc.leaves.event.bot.BotCreateEvent;
import org.leavesmc.leaves.event.bot.BotInventoryOpenEvent;
import org.leavesmc.leaves.event.bot.BotJoinEvent;
import org.leavesmc.leaves.util.MathUtils;

public class ServerBot
extends ServerPlayer {
    private final Map<String, BotAction> actions;
    private final boolean removeOnDeath;
    private final int tracingRange;
    private Vec3 velocity;
    private int fireTicks;
    private int jumpTicks;
    private int noFallTicks;
    public boolean waterSwim;
    private Vec3 knockback;
    public BotCreateState createState;
    public UUID createPlayer;
    private final ServerStatsCounter stats;
    private final BotInventoryContainer container;
    private static final List<ServerBot> bots = new CopyOnWriteArrayList<ServerBot>();
    public boolean spawnPhantom;
    public int notSleepTicks;
    public boolean alwaysSendData;

    private ServerBot(MinecraftServer server, ServerLevel world, GameProfile profile) {
        super(server, world, profile, ClientInformation.createDefault());
        this.entityData.set(new EntityDataAccessor<Integer>(16, EntityDataSerializers.INT), 255);
        this.entityData.set(Player.DATA_PLAYER_MODE_CUSTOMISATION, (byte)-2);
        this.gameMode = new ServerBotGameMode(this);
        this.velocity = new Vec3(this.xxa, this.yya, this.zza);
        this.noFallTicks = 60;
        this.fireTicks = 0;
        this.actions = new HashMap<String, BotAction>();
        this.removeOnDeath = true;
        this.stats = new BotStatsCounter(server);
        this.container = new BotInventoryContainer(this);
        this.waterSwim = true;
        this.knockback = Vec3.ZERO;
        this.tracingRange = world.spigotConfig.playerTrackingRange * world.spigotConfig.playerTrackingRange;
        this.notSleepTicks = 0;
        this.fauxSleeping = LeavesConfig.fakeplayerSkipSleep;
        this.spawnPhantom = LeavesConfig.fakeplayerSpawnPhantom;
        this.alwaysSendData = LeavesConfig.alwaysSendFakeplayerData;
    }

    public static ServerBot createBot(@NotNull BotCreateState state) {
        if (!ServerBot.isCreateLegal(state.name)) {
            return null;
        }
        MinecraftServer server = MinecraftServer.getServer();
        BotCreateEvent event = new BotCreateEvent(state.name, state.skinName, state.loc, String.valueOf(ChatColor.YELLOW) + state.name + " joined the game");
        server.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        Location location = event.getCreateLocation();
        ServerLevel world = ((CraftWorld)location.getWorld()).getHandle();
        CustomGameProfile profile = new CustomGameProfile(BotUtil.getBotUUID(state), state.name, state.skin);
        ServerBot bot = new ServerBot(server, world, profile);
        bot.connection = new ServerGamePacketListenerImpl(server, new Connection(PacketFlow.SERVERBOUND){

            @Override
            public void send(@NotNull Packet<?> packet) {
            }

            @Override
            public void send(@NotNull Packet<?> packet, @Nullable PacketSendListener packetsendlistener) {
            }

            @Override
            public void send(@NotNull Packet<?> packet, @Nullable PacketSendListener callbacks, boolean flush) {
            }
        }, bot, CommonListenerCookie.createInitial(profile, false));
        bot.isRealPlayer = true;
        bot.createState = state;
        if (event.getJoinMessage() != null) {
            Bukkit.broadcastMessage((String)event.getJoinMessage());
        }
        bot.teleportTo(location.getX(), location.getY(), location.getZ());
        bot.setRot(location.getYaw(), location.getPitch());
        bot.getBukkitEntity().setRotation(location.getYaw(), location.getPitch());
        world.addFreshEntity(bot, CreatureSpawnEvent.SpawnReason.COMMAND);
        bot.renderAll();
        server.getPlayerList().addNewBot(bot);
        bots.add(bot);
        BotJoinEvent event1 = new BotJoinEvent(bot.getBukkitPlayer());
        server.server.getPluginManager().callEvent((Event)event1);
        return bot;
    }

    public static boolean isCreateLegal(@NotNull String name) {
        if (!name.matches("^[a-zA-Z0-9_]{4,16}$")) {
            return false;
        }
        if (Bukkit.getPlayer((String)name) != null || ServerBot.getBot(name) != null) {
            return false;
        }
        if (LeavesConfig.unableFakeplayerNames.contains(name)) {
            return false;
        }
        return ServerBot.getBots().size() < LeavesConfig.fakeplayerLimit;
    }

    public void renderAll() {
        MinecraftServer.getServer().getPlayerList().getPlayers().forEach(player -> {
            this.sendPlayerInfo((ServerPlayer)player);
            this.sendFakeData(player.connection, false);
        });
    }

    public void sendPlayerInfo(ServerPlayer player) {
        player.connection.send(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LISTED, ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME), (Collection<ServerPlayer>)List.of(this)));
    }

    public boolean needSendFakeData(ServerPlayer player) {
        return this.alwaysSendData && player.level() == this.level() && player.position().distanceToSqr(this.position()) > (double)this.tracingRange;
    }

    public void sendFakeDataIfNeed(ServerPlayer player, boolean login) {
        if (this.needSendFakeData(player)) {
            this.sendFakeData(player.connection, login);
        }
    }

    public void sendFakeData(ServerPlayerConnection playerConnection, boolean login) {
        playerConnection.send(new ClientboundAddEntityPacket(this));
        if (login) {
            Bukkit.getScheduler().runTaskLater(CraftScheduler.MINECRAFT, () -> this.connection.send(new ClientboundRotateHeadPacket(this, (byte)(this.getYRot() * 256.0f / 360.0f))), 10L);
        } else {
            this.connection.send(new ClientboundRotateHeadPacket(this, (byte)(this.getYRot() * 256.0f / 360.0f)));
        }
    }

    private void sendPacket(Packet<?> packet) {
        MinecraftServer.getServer().getPlayerList().getPlayers().forEach(player -> player.connection.send(packet));
    }

    @Override
    public void die(@NotNull DamageSource damageSource) {
        super.die(damageSource);
        this.dieCheck();
    }

    private void dieCheck() {
        if (this.removeOnDeath) {
            bots.remove(this);
            this.server.getPlayerList().removeBot(this);
            this.remove(Entity.RemovalReason.KILLED);
            this.setDead();
            this.removeTab();
            Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + this.getName().getString() + " left the game"));
        }
    }

    private void removeTab() {
        this.sendPacket(new ClientboundPlayerInfoRemovePacket(List.of(this.getUUID())));
    }

    private void setDead() {
        this.sendPacket(new ClientboundRemoveEntitiesPacket(this.getId()));
        this.dead = true;
        this.inventoryMenu.removed(this);
        this.containerMenu.removed(this);
    }

    @Override
    @Nullable
    public Entity changeDimension(@NotNull ServerLevel destination) {
        return null;
    }

    public Bot getBukkitPlayer() {
        return this.getBukkitEntity();
    }

    @Override
    @NotNull
    public CraftBot getBukkitEntity() {
        return (CraftBot)super.getBukkitEntity();
    }

    @Override
    public boolean isInWater() {
        Location loc = this.getLocation();
        for (int i = 0; i <= 2; ++i) {
            Material type = loc.getBlock().getType();
            if (type == Material.WATER || type == Material.LAVA) {
                return true;
            }
            loc.add(0.0, 0.9, 0.0);
        }
        return false;
    }

    @Override
    public void tick() {
        super.tick();
        this.doTick();
        if (!this.isAlive()) {
            return;
        }
        if (this.spawnPhantom) {
            ++this.notSleepTicks;
        }
        if (this.fireTicks > 0) {
            --this.fireTicks;
        }
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
        if (this.noFallTicks > 0) {
            --this.noFallTicks;
        }
        if (this.takeXpDelay > 0) {
            --this.takeXpDelay;
        }
        this.updateLocation();
        this.updatePlayerPose();
        if (this.server.getTickCount() % 20 == 0) {
            float regenAmount;
            float maxHealth;
            float health = this.getHealth();
            float amount = health < (maxHealth = this.getMaxHealth()) - (regenAmount = (float)(LeavesConfig.fakeplayerRegenAmount * 20.0)) ? health + regenAmount : maxHealth;
            this.setHealth(amount);
        }
        BlockPos blockposition = this.getOnPosLegacy();
        BlockState iblockdata = this.level().getBlockState(blockposition);
        Vec3 vec3d1 = this.collide(this.velocity);
        this.checkFallDamage(vec3d1.y, this.onGround(), iblockdata, blockposition);
        ++this.attackStrengthTicker;
        if (this.getHealth() > 0.0f) {
            AABB axisalignedbb = this.isPassenger() && !this.getVehicle().isRemoved() ? this.getBoundingBox().minmax(this.getVehicle().getBoundingBox()).inflate(1.0, 0.0, 1.0) : this.getBoundingBox().inflate(1.0, 0.5, 1.0);
            List<Entity> list = this.level().getEntities(this, axisalignedbb);
            ArrayList list1 = Lists.newArrayList();
            for (Entity entity : list) {
                if (entity.getType() == EntityType.EXPERIENCE_ORB) {
                    list1.add(entity);
                    continue;
                }
                if (entity.isRemoved()) continue;
                this.touch(entity);
            }
            if (!list1.isEmpty()) {
                this.touch((Entity)Util.getRandom(list1, this.random));
            }
        }
        Iterator<Map.Entry<String, BotAction>> iterator = this.actions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, BotAction> entry = iterator.next();
            if (entry.getValue().isCancel()) {
                iterator.remove();
                continue;
            }
            entry.getValue().tryTick(this);
        }
    }

    private void touch(@NotNull Entity entity) {
        entity.playerTouch(this);
    }

    @Override
    public void onItemPickup(@NotNull ItemEntity item) {
        super.onItemPickup(item);
        this.updateItemInHand(InteractionHand.MAIN_HAND);
    }

    public void updateItemInHand(InteractionHand hand) {
        ItemStack item = this.getItemInHand(hand);
        if (!item.isEmpty()) {
            BotUtil.replenishment(item, this.getInventory().items);
            if (BotUtil.isDamage(item, 10)) {
                BotUtil.replaceTool(hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND, this);
            }
        }
        this.detectEquipmentUpdatesPublic();
    }

    @Override
    public void checkFallDamage(double heightDifference, boolean onGround, @NotNull BlockState state, @NotNull BlockPos landedPosition) {
        if (onGround) {
            if (this.fallDistance > 0.0f) {
                state.getBlock().fallOn(this.level(), state, landedPosition, this, this.fallDistance);
                this.level().gameEvent(GameEvent.HIT_GROUND, this.position(), GameEvent.Context.of(this, this.mainSupportingBlockPos.map(blockposition1 -> this.level().getBlockState((BlockPos)blockposition1)).orElse(state)));
            }
            this.resetFallDistance();
        } else if (heightDifference < 0.0) {
            this.fallDistance -= (float)heightDifference;
        }
    }

    @Override
    public void doTick() {
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        this.baseTick();
        this.lerpSteps = (int)this.zza;
        this.animStep = this.run;
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public Location getLocation() {
        return this.getBukkitPlayer().getLocation();
    }

    @Override
    public void knockback(double strength, double x, double z, @Nullable Entity attacker, @NotNull EntityKnockbackEvent.Cause cause) {
        if ((strength *= 1.0 - this.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE)) > 0.0) {
            this.hasImpulse = true;
            Vec3 vec3d = this.getDeltaMovement();
            Vec3 vec3d1 = new Vec3(x, 0.0, z).normalize().scale(strength);
            this.knockback = new Vec3(vec3d.x / 2.0 - vec3d1.x, this.onGround() ? Math.min(0.4, vec3d.y / 2.0 + strength) : vec3d.y, vec3d.z / 2.0 - vec3d1.z);
        }
    }

    private void updateLocation() {
        this.velocity = new Vec3(this.xxa, this.yya, this.zza);
        if (this.waterSwim && this.isInWater()) {
            this.addDeltaMovement(new Vec3(0.0, 0.05, 0.0));
        }
        this.addDeltaMovement(this.knockback);
        this.knockback = Vec3.ZERO;
        this.travel(this.velocity);
    }

    public void faceLocation(@NotNull Location loc) {
        this.look(loc.toVector().subtract(this.getLocation().toVector()), false);
    }

    public void look(Vector dir, boolean keepYaw) {
        float pitch;
        float yaw;
        if (keepYaw) {
            yaw = this.getYHeadRot();
            pitch = MathUtils.fetchPitch(dir);
        } else {
            float[] vals = MathUtils.fetchYawPitch(dir);
            yaw = vals[0];
            pitch = vals[1];
            this.sendPacket(new ClientboundRotateHeadPacket(this, (byte)(yaw * 256.0f / 360.0f)));
        }
        this.setRot(yaw, pitch);
        this.getBukkitEntity().setRotation(yaw, pitch);
    }

    @Override
    public void attack(@NotNull Entity target) {
        super.attack(target);
        this.swing(InteractionHand.MAIN_HAND);
    }

    @Override
    public void jumpFromGround() {
        double jumpPower = (double)this.getJumpPower() + (double)this.getJumpBoostPower();
        this.addDeltaMovement(new Vec3(0.0, jumpPower, 0.0));
    }

    public void dropAll() {
        this.getInventory().dropAll();
        this.detectEquipmentUpdatesPublic();
    }

    public void setBotAction(BotAction action) {
        if (!LeavesConfig.fakeplayerUseAction) {
            return;
        }
        if (action instanceof StopAction) {
            this.actions.clear();
        }
        action.init();
        this.actions.put(action.getName(), action);
    }

    public Collection<BotAction> getBotActions() {
        return this.actions.values();
    }

    public BotAction getBotAction(String name) {
        return this.actions.get(name);
    }

    @Deprecated
    public BotAction getBotAction() {
        return null;
    }

    @Override
    @NotNull
    public ServerStatsCounter getStats() {
        return this.stats;
    }

    public BotInventoryContainer getContainer() {
        return this.container;
    }

    @Override
    @NotNull
    public InteractionResult interact(@NotNull Player player, @NotNull InteractionHand hand) {
        if (LeavesConfig.openFakeplayerInventory && player instanceof ServerPlayer) {
            ServerPlayer player1 = (ServerPlayer)player;
            if (player.getMainHandItem().isEmpty()) {
                BotInventoryOpenEvent event = new BotInventoryOpenEvent((Bot)this.getBukkitEntity(), (org.bukkit.entity.Player)player1.getBukkitEntity());
                this.server.server.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    player.openMenu(new SimpleMenuProvider((i, inventory, p) -> ChestMenu.sixRows(i, inventory, this.container), this.getDisplayName()));
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.interact(player, hand);
    }

    public static ServerBot getBot(ServerPlayer player) {
        ServerBot bot = null;
        for (ServerBot b : bots) {
            if (b.getId() != player.getId()) continue;
            bot = b;
            break;
        }
        return bot;
    }

    public static ServerBot getBot(String name) {
        ServerBot bot = null;
        for (ServerBot b : bots) {
            if (!b.getName().getString().equals(name)) continue;
            bot = b;
            break;
        }
        return bot;
    }

    public static ServerBot getBot(UUID uuid) {
        ServerBot bot = null;
        for (ServerBot b : bots) {
            if (b.uuid != uuid) continue;
            bot = b;
            break;
        }
        return bot;
    }

    public static void saveOrRemoveAllBot() {
        if (LeavesConfig.fakeplayerSupport && LeavesConfig.fakeplayerResident) {
            JsonObject fakePlayerList = new JsonObject();
            bots.forEach(bot -> fakePlayerList.add(bot.createState.realName, (JsonElement)BotUtil.saveBot(bot)));
            File file = MinecraftServer.getServer().getWorldPath(LevelResource.ROOT).resolve("fake_player.leaves.json").toFile();
            if (!file.isFile()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try (BufferedWriter bfw = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                bfw.write(new Gson().toJson((JsonElement)fakePlayerList));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            ServerBot.removeAllBot();
        }
    }

    public static void loadAllBot() {
        if (LeavesConfig.fakeplayerSupport && LeavesConfig.fakeplayerResident) {
            JsonObject fakePlayerList = new JsonObject();
            File file = MinecraftServer.getServer().getWorldPath(LevelResource.ROOT).resolve("fake_player.leaves.json").toFile();
            if (!file.isFile()) {
                return;
            }
            try (BufferedReader bfr = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                fakePlayerList = (JsonObject)new Gson().fromJson((Reader)bfr, JsonObject.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (Map.Entry entry : fakePlayerList.entrySet()) {
                BotUtil.loadBot(entry);
            }
            file.delete();
        }
    }

    public static boolean removeAllBot() {
        for (ServerBot bot : bots) {
            bot.die(bot.damageSources().fellOutOfWorld());
        }
        return true;
    }

    public static List<ServerBot> getBots() {
        return bots;
    }

    public static class BotCreateState {
        public Location loc;
        public String[] skin;
        public String skinName;
        private String realName;
        private String name;

        public BotCreateState(Location loc, String realName, String skinName) {
            this.loc = loc;
            this.skinName = skinName;
            this.setRealName(realName);
        }

        public BotCreateState(Location loc, String name, String realName, String skinName, String[] skin) {
            this.loc = loc;
            this.skinName = skinName;
            this.skin = skin;
            this.realName = realName;
            this.name = name;
        }

        public ServerBot createSync() {
            return ServerBot.createBot(this);
        }

        public void createAsync(Consumer<ServerBot> consumer) {
            Bukkit.getScheduler().runTaskAsynchronously(CraftScheduler.MINECRAFT, () -> {
                if (this.skinName != null) {
                    this.skin = MojangAPI.getSkin(this.skinName);
                }
                Bukkit.getScheduler().runTask(CraftScheduler.MINECRAFT, () -> {
                    ServerBot bot = ServerBot.createBot(this);
                    if (bot != null && consumer != null) {
                        consumer.accept(bot);
                    }
                });
            });
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setRealName(String realName) {
            this.realName = realName;
            this.name = LeavesConfig.fakeplayerPrefix + realName + LeavesConfig.fakeplayerSuffix;
        }

        public String getName() {
            return this.name;
        }

        public String getRealName() {
            return this.realName;
        }
    }

    public static class CustomGameProfile
    extends GameProfile {
        public CustomGameProfile(UUID uuid, String name, String[] skin) {
            super(uuid, name);
            this.setSkin(skin);
        }

        public void setSkin(String[] skin) {
            if (skin != null) {
                this.getProperties().put((Object)"textures", (Object)new Property("textures", skin[0], skin[1]));
            }
        }
    }
}

