/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.bot.agent;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.leavesmc.leaves.bot.agent.BotAction;
import org.leavesmc.leaves.bot.agent.actions.AttackAction;
import org.leavesmc.leaves.bot.agent.actions.AttackSelfAction;
import org.leavesmc.leaves.bot.agent.actions.BreakBlockAction;
import org.leavesmc.leaves.bot.agent.actions.DropAction;
import org.leavesmc.leaves.bot.agent.actions.FishAction;
import org.leavesmc.leaves.bot.agent.actions.JumpAction;
import org.leavesmc.leaves.bot.agent.actions.LookAction;
import org.leavesmc.leaves.bot.agent.actions.RotateAction;
import org.leavesmc.leaves.bot.agent.actions.SneakAction;
import org.leavesmc.leaves.bot.agent.actions.StopAction;
import org.leavesmc.leaves.bot.agent.actions.SwimAction;
import org.leavesmc.leaves.bot.agent.actions.UseItemAction;
import org.leavesmc.leaves.bot.agent.actions.UseItemOffHandAction;
import org.leavesmc.leaves.bot.agent.actions.UseItemOnAction;
import org.leavesmc.leaves.bot.agent.actions.UseItemOnOffhandAction;
import org.leavesmc.leaves.bot.agent.actions.UseItemToAction;
import org.leavesmc.leaves.bot.agent.actions.UseItemToOffhandAction;

public class Actions {
    private static final Map<String, BotAction> actions = new HashMap<String, BotAction>();

    public static void registerAll() {
        Actions.register(new AttackAction());
        Actions.register(new BreakBlockAction());
        Actions.register(new DropAction());
        Actions.register(new JumpAction());
        Actions.register(new RotateAction());
        Actions.register(new SneakAction());
        Actions.register(new StopAction());
        Actions.register(new UseItemAction());
        Actions.register(new UseItemOnAction());
        Actions.register(new UseItemToAction());
        Actions.register(new LookAction());
        Actions.register(new FishAction());
        Actions.register(new AttackSelfAction());
        Actions.register(new SwimAction());
        Actions.register(new UseItemOffHandAction());
        Actions.register(new UseItemOnOffhandAction());
        Actions.register(new UseItemToOffhandAction());
    }

    public static boolean register(@NotNull BotAction action) {
        if (!actions.containsKey(action.getName())) {
            actions.put(action.getName(), action);
            return true;
        }
        return false;
    }

    public static boolean unregister(@NotNull String name) {
        if (actions.containsKey(name)) {
            actions.remove(name);
            return true;
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static Collection<BotAction> getAll() {
        return actions.values();
    }

    @NotNull
    public static Set<String> getNames() {
        return actions.keySet();
    }

    public static BotAction getForName(String name) {
        return actions.get(name);
    }
}

