/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.bot.agent;

import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.leavesmc.leaves.bot.ServerBot;
import org.leavesmc.leaves.command.CommandArgument;
import org.leavesmc.leaves.command.CommandArgumentResult;

public abstract class BotAction {
    private final String name;
    private final CommandArgument argument;
    private boolean cancel;
    private int tickDelay;
    private int number;
    private int needWaitTick;
    private int canDoNumber;

    public BotAction(String name, CommandArgument argument) {
        this.name = name;
        this.argument = argument;
        this.cancel = false;
        this.tickDelay = 20;
        this.number = -1;
    }

    public String getName() {
        return this.name;
    }

    public int getTickDelay() {
        return this.tickDelay;
    }

    public int getNumber() {
        return this.number;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public BotAction setTickDelay(int tickDelay) {
        this.tickDelay = Math.max(0, tickDelay);
        return this;
    }

    public BotAction setTabComplete(int index, List<String> list) {
        this.argument.setTabComplete(index, list);
        return this;
    }

    public BotAction setNumber(int number) {
        this.number = Math.max(-1, number);
        return this;
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }

    public void init() {
        this.needWaitTick = 0;
        this.canDoNumber = this.getNumber();
        this.setCancel(false);
    }

    public void tryTick(ServerBot bot) {
        if (this.canDoNumber == 0) {
            this.setCancel(true);
            return;
        }
        if (this.needWaitTick-- <= 0 && this.doTick(bot)) {
            --this.canDoNumber;
            this.needWaitTick = this.getTickDelay();
        }
    }

    public CommandArgument getArgument() {
        return this.argument;
    }

    public abstract BotAction getNew(@NotNull ServerPlayer var1, @NotNull CommandArgumentResult var2);

    public abstract boolean doTick(@NotNull ServerBot var1);
}

