/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.bot.agent.actions;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.jetbrains.annotations.NotNull;
import org.leavesmc.leaves.bot.ServerBot;
import org.leavesmc.leaves.bot.agent.BotAction;
import org.leavesmc.leaves.command.CommandArgument;
import org.leavesmc.leaves.command.CommandArgumentResult;
import org.leavesmc.leaves.command.CommandArgumentType;

public class BreakBlockAction
extends BotAction {
    private int delay = 0;
    private int nowDelay = 0;
    private BlockPos lastPos = null;
    private int destroyProgressTime = 0;
    private int lastSentState = -1;

    public BreakBlockAction() {
        super("break", new CommandArgument(CommandArgumentType.INTEGER, CommandArgumentType.INTEGER));
        this.setTabComplete(0, List.of("[TickDelay]"));
        this.setTabComplete(1, List.of("[DoNumber]"));
    }

    @Override
    public BotAction getNew(@NotNull ServerPlayer player, @NotNull CommandArgumentResult result) {
        return new BreakBlockAction().setTickDelay(result.readInt(20)).setNumber(result.readInt(-1));
    }

    @Override
    public BotAction setTickDelay(int tickDelay) {
        super.setTickDelay(0);
        this.delay = tickDelay;
        return this;
    }

    @Override
    public boolean doTick(@NotNull ServerBot bot) {
        if (this.nowDelay > 0) {
            --this.nowDelay;
            return false;
        }
        Block block = bot.getBukkitEntity().getTargetBlockExact(5);
        if (block != null) {
            BlockState iblockdata;
            BlockPos pos = ((CraftBlock)block).getPosition();
            if (this.lastPos == null || !this.lastPos.equals(pos)) {
                this.lastPos = pos;
                this.destroyProgressTime = 0;
                this.lastSentState = -1;
            }
            if (!(iblockdata = bot.level().getBlockState(pos)).isAir()) {
                bot.swing(InteractionHand.MAIN_HAND);
                if (iblockdata.getDestroyProgress(bot, bot.level(), pos) >= 1.0f) {
                    bot.gameMode.destroyAndAck(pos, 0, "insta mine");
                    bot.level().destroyBlockProgress(bot.getId(), pos, -1);
                    bot.updateItemInHand(InteractionHand.MAIN_HAND);
                    this.finalBreak();
                    return true;
                }
                float damage = this.incrementDestroyProgress(bot, iblockdata, pos);
                if (damage >= 1.0f) {
                    bot.gameMode.destroyAndAck(pos, 0, "destroyed");
                    bot.level().destroyBlockProgress(bot.getId(), pos, -1);
                    bot.updateItemInHand(InteractionHand.MAIN_HAND);
                    this.finalBreak();
                    return true;
                }
            }
        }
        return false;
    }

    private void finalBreak() {
        this.lastPos = null;
        this.destroyProgressTime = 0;
        this.lastSentState = -1;
        this.nowDelay = this.delay;
    }

    private float incrementDestroyProgress(ServerBot bot, @NotNull BlockState state, BlockPos pos) {
        float f = state.getDestroyProgress(bot, bot.level(), pos) * (float)(++this.destroyProgressTime);
        int k = (int)(f * 10.0f);
        if (k != this.lastSentState) {
            bot.level().destroyBlockProgress(bot.getId(), pos, k);
            this.lastSentState = k;
        }
        return f;
    }
}

