/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.bot.agent.actions;

import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.leavesmc.leaves.bot.ServerBot;
import org.leavesmc.leaves.bot.agent.BotAction;
import org.leavesmc.leaves.command.CommandArgument;
import org.leavesmc.leaves.command.CommandArgumentResult;
import org.leavesmc.leaves.command.CommandArgumentType;

public class FishAction
extends BotAction {
    private int delay = 0;
    private int nowDelay = 0;

    public FishAction() {
        super("fish", new CommandArgument(CommandArgumentType.INTEGER, CommandArgumentType.INTEGER));
        this.setTabComplete(0, List.of("[TickDelay]"));
        this.setTabComplete(1, List.of("[DoNumber]"));
    }

    @Override
    public BotAction getNew(@NotNull ServerPlayer player, @NotNull CommandArgumentResult result) {
        return new FishAction().setTickDelay(result.readInt(20)).setNumber(result.readInt(-1));
    }

    @Override
    public BotAction setTickDelay(int tickDelay) {
        super.setTickDelay(0);
        this.delay = tickDelay;
        return this;
    }

    @Override
    public boolean doTick(@NotNull ServerBot bot) {
        if (this.nowDelay > 0) {
            --this.nowDelay;
            return false;
        }
        ItemStack mainHand = bot.getMainHandItem();
        if (mainHand == ItemStack.EMPTY || mainHand.getItem().getClass() != FishingRodItem.class) {
            return false;
        }
        FishingHook fishingHook = bot.fishing;
        if (fishingHook != null) {
            if (fishingHook.currentState == FishingHook.FishHookState.HOOKED_IN_ENTITY) {
                mainHand.use(bot.level(), bot, InteractionHand.MAIN_HAND);
                this.nowDelay = 20;
                return false;
            }
            if (fishingHook.nibble > 0) {
                mainHand.use(bot.level(), bot, InteractionHand.MAIN_HAND);
                this.nowDelay = this.delay;
                return true;
            }
        } else {
            mainHand.use(bot.level(), bot, InteractionHand.MAIN_HAND);
        }
        return false;
    }
}

