/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.bot.agent.actions;

import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.leavesmc.leaves.bot.ServerBot;
import org.leavesmc.leaves.bot.agent.BotAction;
import org.leavesmc.leaves.command.CommandArgument;
import org.leavesmc.leaves.command.CommandArgumentResult;
import org.leavesmc.leaves.command.CommandArgumentType;

public class LookAction
extends BotAction {
    private Vector pos;

    public LookAction() {
        super("look", new CommandArgument(CommandArgumentType.DOUBLE, CommandArgumentType.DOUBLE, CommandArgumentType.DOUBLE));
        this.setTabComplete(0, List.of("<X>"));
        this.setTabComplete(1, List.of("<Y>"));
        this.setTabComplete(2, List.of("<Z>"));
    }

    @Override
    public BotAction getNew(@NotNull ServerPlayer player, @NotNull CommandArgumentResult result) {
        Vector pos = result.readVector();
        if (pos != null) {
            return new LookAction().setPos(pos).setTickDelay(0).setNumber(1);
        }
        return null;
    }

    public LookAction setPos(Vector pos) {
        if (pos != null) {
            this.pos = pos;
            return this;
        }
        return null;
    }

    @Override
    public boolean doTick(@NotNull ServerBot bot) {
        bot.look(this.pos.subtract(bot.getLocation().toVector()), false);
        return true;
    }
}

