/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.bot.agent.actions;

import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TrappedChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.scheduler.CraftScheduler;
import org.jetbrains.annotations.NotNull;
import org.leavesmc.leaves.bot.ServerBot;
import org.leavesmc.leaves.bot.agent.BotAction;
import org.leavesmc.leaves.command.CommandArgument;
import org.leavesmc.leaves.command.CommandArgumentResult;
import org.leavesmc.leaves.command.CommandArgumentType;

public class UseItemOnOffhandAction
extends BotAction {
    public UseItemOnOffhandAction() {
        super("use_on_offhand", new CommandArgument(CommandArgumentType.INTEGER, CommandArgumentType.INTEGER));
        this.setTabComplete(0, List.of("[TickDelay]"));
        this.setTabComplete(1, List.of("[DoNumber]"));
    }

    @Override
    public BotAction getNew(@NotNull ServerPlayer player, @NotNull CommandArgumentResult result) {
        return new UseItemOnOffhandAction().setTickDelay(result.readInt(20)).setNumber(result.readInt(-1));
    }

    @Override
    public boolean doTick(@NotNull ServerBot bot) {
        HitResult result = bot.getRayTrace(5, ClipContext.Fluid.NONE);
        if (result instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)result;
            BlockState state = bot.serverLevel().getBlockState(blockHitResult.getBlockPos());
            bot.swing(InteractionHand.OFF_HAND);
            if (state.getBlock() == Blocks.TRAPPED_CHEST) {
                BlockEntity entity = bot.serverLevel().getBlockEntity(blockHitResult.getBlockPos());
                if (entity instanceof TrappedChestBlockEntity) {
                    TrappedChestBlockEntity chestBlockEntity = (TrappedChestBlockEntity)entity;
                    chestBlockEntity.startOpen(bot);
                    Bukkit.getScheduler().runTaskLater(CraftScheduler.MINECRAFT, () -> chestBlockEntity.stopOpen(bot), 1L);
                    return true;
                }
            } else {
                bot.updateItemInHand(InteractionHand.OFF_HAND);
                return bot.gameMode.useItemOn(bot, bot.level(), bot.getItemInHand(InteractionHand.OFF_HAND), InteractionHand.OFF_HAND, (BlockHitResult)result).consumesAction();
            }
        }
        return false;
    }
}

