/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.bytebuf;

import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.leavesmc.leaves.bytebuf.Bytebuf;

public class WrappedBytebuf
implements Bytebuf {
    private final FriendlyByteBuf buf;
    private final RegistryFriendlyByteBuf registryBuf;

    public WrappedBytebuf(ByteBuf buf) {
        if (buf instanceof RegistryFriendlyByteBuf) {
            this.buf = (FriendlyByteBuf)buf;
            this.registryBuf = (RegistryFriendlyByteBuf)buf;
        } else {
            this.buf = new FriendlyByteBuf(buf);
            this.registryBuf = new RegistryFriendlyByteBuf(this.buf, MinecraftServer.getServer().registryAccess());
        }
    }

    public RegistryFriendlyByteBuf getRegistryBuf() {
        return this.registryBuf;
    }

    public byte[] toArray() {
        return this.buf.array();
    }

    public Bytebuf skipBytes(int i) {
        this.buf.skipBytes(i);
        return this;
    }

    public int readerIndex() {
        return this.buf.readerIndex();
    }

    public Bytebuf readerIndex(int i) {
        this.buf.readerIndex(i);
        return this;
    }

    public int writerIndex() {
        return this.buf.writerIndex();
    }

    public Bytebuf writerIndex(int i) {
        this.buf.writerIndex(i);
        return this;
    }

    public Bytebuf resetReaderIndex() {
        this.buf.resetReaderIndex();
        return this;
    }

    public Bytebuf resetWriterIndex() {
        this.buf.resetWriterIndex();
        return this;
    }

    public Bytebuf writeByte(int i) {
        this.buf.writeByte(i);
        return this;
    }

    public byte readByte() {
        return this.buf.readByte();
    }

    public Bytebuf writeBoolean(boolean b) {
        this.buf.writeBoolean(b);
        return this;
    }

    public boolean readBoolean() {
        return this.buf.readBoolean();
    }

    public Bytebuf writeFloat(float f) {
        this.buf.writeFloat(f);
        return this;
    }

    public float readFloat() {
        return this.buf.readFloat();
    }

    public Bytebuf writeDouble(double d) {
        this.buf.writeDouble(d);
        return this;
    }

    public double readDouble() {
        return this.buf.readDouble();
    }

    public Bytebuf writeShort(int i) {
        this.buf.writeShort(i);
        return this;
    }

    public short readShort() {
        return this.buf.readShort();
    }

    public Bytebuf writeInt(int i) {
        this.buf.writeShort(i);
        return this;
    }

    public int readInt() {
        return this.buf.readInt();
    }

    public Bytebuf writeLong(long i) {
        this.buf.writeLong(i);
        return this;
    }

    public long readLong() {
        return this.buf.readLong();
    }

    public Bytebuf writeVarInt(int i) {
        this.buf.writeVarInt(i);
        return this;
    }

    public int readVarInt() {
        return this.buf.readVarInt();
    }

    public Bytebuf writeVarLong(long i) {
        this.buf.writeVarLong(i);
        return this;
    }

    public long readVarLong() {
        return this.buf.readVarLong();
    }

    public Bytebuf writeUUID(UUID uuid) {
        this.buf.writeUUID(uuid);
        return this;
    }

    public UUID readUUID() {
        return this.buf.readUUID();
    }

    public Bytebuf writeEnum(Enum<?> instance) {
        this.buf.writeEnum(instance);
        return this;
    }

    public <T extends Enum<T>> T readEnum(Class<T> enumClass) {
        return this.buf.readEnum(enumClass);
    }

    public Bytebuf writeUTFString(String utf) {
        this.buf.writeUtf(utf);
        return this;
    }

    public String readUTFString() {
        return this.buf.readUtf();
    }

    public Bytebuf writeComponentPlain(String str) {
        ComponentSerialization.STREAM_CODEC.encode(new RegistryFriendlyByteBuf(this.buf, RegistryAccess.EMPTY), Component.literal(str));
        return this;
    }

    public String readComponentPlain() {
        return ((Component)ComponentSerialization.STREAM_CODEC.decode(new RegistryFriendlyByteBuf(this.buf, RegistryAccess.EMPTY))).getString();
    }

    public Bytebuf writeComponentJson(JsonElement json) {
        MutableComponent component = Component.Serializer.fromJson(json, (HolderLookup.Provider)RegistryAccess.EMPTY);
        if (component == null) {
            throw new IllegalArgumentException("Null can not be serialize to Minecraft chat component");
        }
        ComponentSerialization.STREAM_CODEC.encode(new RegistryFriendlyByteBuf(this.buf, RegistryAccess.EMPTY), component);
        return this;
    }

    public JsonElement readComponentJson() {
        return Component.Serializer.serialize((Component)ComponentSerialization.STREAM_CODEC.decode(new RegistryFriendlyByteBuf(this.buf, RegistryAccess.EMPTY)), RegistryAccess.EMPTY);
    }

    public Bytebuf writeItemStack(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.unwrap(itemStack);
        net.minecraft.world.item.ItemStack.OPTIONAL_STREAM_CODEC.encode(this.registryBuf, nmsItem);
        return this;
    }

    public ItemStack readItemStack() {
        net.minecraft.world.item.ItemStack nmsItem = (net.minecraft.world.item.ItemStack)net.minecraft.world.item.ItemStack.OPTIONAL_STREAM_CODEC.decode(this.registryBuf);
        return nmsItem.asBukkitMirror();
    }

    public Bytebuf copy() {
        return new WrappedBytebuf(this.buf.copy());
    }

    public boolean release() {
        return this.buf.release();
    }
}

