/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.bytebuf.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.minecraft.network.Connection;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.BundleDelimiterPacket;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;
import org.leavesmc.leaves.LeavesConfig;
import org.leavesmc.leaves.bytebuf.Bytebuf;
import org.leavesmc.leaves.bytebuf.BytebufManager;
import org.leavesmc.leaves.bytebuf.SimpleBytebufManager;
import org.leavesmc.leaves.bytebuf.WrappedBytebuf;
import org.leavesmc.leaves.bytebuf.packet.Packet;
import org.leavesmc.leaves.bytebuf.packet.PacketListener;
import org.leavesmc.leaves.bytebuf.packet.PacketType;

public class InternalBytebufHandler {
    public final Map<PacketListener, Plugin> listenerMap = new HashMap<PacketListener, Plugin>();
    private final BytebufManager manager = new SimpleBytebufManager(this);
    private final ImmutableMap<PacketType, StreamCodec> type2CodecMap;
    private final Cache<net.minecraft.network.protocol.PacketType<?>, PacketType> resultCache = CacheBuilder.newBuilder().build();

    public InternalBytebufHandler() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (PacketType packet : PacketType.values()) {
            Class<?> packetClass;
            try {
                packetClass = Class.forName("net.minecraft.network.protocol.game." + packet.name() + "Packet");
            }
            catch (ClassNotFoundException e) {
                try {
                    packetClass = Class.forName("net.minecraft.network.protocol.common." + packet.name() + "Packet");
                }
                catch (ClassNotFoundException e2) {
                    try {
                        packetClass = Class.forName("net.minecraft.network.protocol.ping." + packet.name() + "Packet");
                    }
                    catch (ClassNotFoundException ignored) {
                        continue;
                    }
                }
            }
            try {
                Field field = packetClass.getDeclaredField("STREAM_CODEC");
                builder.put((Object)packet, (Object)((StreamCodec)field.get(null)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        builder.put((Object)PacketType.ClientboundMoveEntityPos, ClientboundMoveEntityPacket.Pos.STREAM_CODEC);
        builder.put((Object)PacketType.ClientboundMoveEntityPosRot, ClientboundMoveEntityPacket.PosRot.STREAM_CODEC);
        builder.put((Object)PacketType.ClientboundMoveEntityRot, ClientboundMoveEntityPacket.Rot.STREAM_CODEC);
        builder.put((Object)PacketType.ServerboundMovePlayerPos, ServerboundMovePlayerPacket.Pos.STREAM_CODEC);
        builder.put((Object)PacketType.ServerboundMovePlayerPosRot, ServerboundMovePlayerPacket.PosRot.STREAM_CODEC);
        builder.put((Object)PacketType.ServerboundMovePlayerRot, ServerboundMovePlayerPacket.Rot.STREAM_CODEC);
        builder.put((Object)PacketType.ServerboundMovePlayerStatusOnly, ServerboundMovePlayerPacket.StatusOnly.STREAM_CODEC);
        builder.put((Object)PacketType.ClientboundCustomPayload, ClientboundCustomPayloadPacket.GAMEPLAY_STREAM_CODEC);
        this.type2CodecMap = builder.build();
    }

    public void injectPlayer(ServerPlayer player) {
        if (LeavesConfig.leavesPacketEvent) {
            player.connection.connection.channel.pipeline().addBefore("packet_handler", "leaves-bytebuf-handler", (ChannelHandler)new PacketHandler(player.getBukkitEntity()));
        }
    }

    public BytebufManager getManager() {
        return this.manager;
    }

    public net.minecraft.network.protocol.Packet<?> callPacketInEvent(Player player, Packet packet) {
        for (PacketListener listener : this.listenerMap.keySet()) {
            if (this.listenerMap.get(listener).isEnabled()) {
                packet = listener.onPacketIn(player, packet);
                packet.bytebuf().resetReaderIndex();
                continue;
            }
            this.listenerMap.remove(listener);
        }
        return this.createNMSPacket(packet);
    }

    public net.minecraft.network.protocol.Packet<?> callPacketOutEvent(Player player, Packet packet) {
        for (PacketListener listener : this.listenerMap.keySet()) {
            if (this.listenerMap.get(listener).isEnabled()) {
                packet = listener.onPacketOut(player, packet);
                packet.bytebuf().resetReaderIndex();
                continue;
            }
            this.listenerMap.remove(listener);
        }
        return this.createNMSPacket(packet);
    }

    public void applyPacketToPlayer(ServerPlayer player, Packet packet) {
        Connection sp = player.connection.connection;
        sp.send(this.createNMSPacket(packet));
    }

    public net.minecraft.network.protocol.Packet<?> createNMSPacket(Packet packet) {
        StreamCodec codec = (StreamCodec)this.type2CodecMap.get((Object)packet.type());
        if (codec == null) {
            throw new UnsupportedOperationException("This feature is not completely finished yet, packet type " + String.valueOf(packet.type()) + " is not supported temporary.");
        }
        return (net.minecraft.network.protocol.Packet)codec.decode(((WrappedBytebuf)packet.bytebuf()).getRegistryBuf());
    }

    @Nullable
    private PacketType toEnumType(net.minecraft.network.protocol.PacketType<?> type) {
        try {
            return (PacketType)this.resultCache.get(type, () -> {
                StringBuilder builder = new StringBuilder();
                String bound = type.toString().split("/")[0];
                String name = type.toString().split(":")[1];
                builder.append(bound.substring(0, 1).toUpperCase()).append(bound.substring(1));
                boolean flag = true;
                for (int i = 0; i < name.length(); ++i) {
                    if (flag) {
                        builder.append(name.substring(i, i + 1).toUpperCase());
                        flag = false;
                        continue;
                    }
                    if (name.charAt(i) == '_') {
                        flag = true;
                        continue;
                    }
                    builder.append(name.charAt(i));
                }
                try {
                    return PacketType.valueOf((String)builder.toString());
                }
                catch (IllegalArgumentException ignored) {
                    return null;
                }
            });
        }
        catch (ExecutionException ignore) {
            return null;
        }
    }

    public Packet createBytebufPacket(PacketType type, net.minecraft.network.protocol.Packet<?> nmsPacket) {
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer((int)8192), MinecraftServer.getServer().registryAccess());
        StreamCodec codec = (StreamCodec)this.type2CodecMap.get((Object)type);
        if (codec == null) {
            throw new UnsupportedOperationException("This feature is not completely finished yet, packet type " + String.valueOf(type) + " is not supported temporary.");
        }
        codec.encode(buf, nmsPacket);
        return new Packet(type, (Bytebuf)new WrappedBytebuf(buf));
    }

    private class PacketHandler
    extends ChannelDuplexHandler {
        private static final String handlerName = "leaves-bytebuf-handler";
        private final Player player;

        public PacketHandler(Player player) {
            this.player = player;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            net.minecraft.network.protocol.Packet nmsPacket;
            PacketType type;
            if (msg instanceof BundlePacket || msg instanceof BundleDelimiterPacket) {
                super.channelRead(ctx, (Object)msg);
                return;
            }
            if (msg instanceof net.minecraft.network.protocol.Packet && (type = InternalBytebufHandler.this.toEnumType((nmsPacket = (net.minecraft.network.protocol.Packet)msg).type())) != null) {
                try {
                    msg = InternalBytebufHandler.this.callPacketInEvent(this.player, InternalBytebufHandler.this.createBytebufPacket(type, nmsPacket));
                }
                catch (Exception e) {
                    MinecraftServer.LOGGER.error("Error on PacketInEvent.", (Throwable)e);
                }
            }
            if (msg != null) {
                super.channelRead(ctx, (Object)msg);
            }
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            net.minecraft.network.protocol.Packet nmsPacket;
            PacketType type;
            if (msg instanceof BundlePacket || msg instanceof BundleDelimiterPacket) {
                super.write(ctx, (Object)msg, promise);
                return;
            }
            if (msg instanceof net.minecraft.network.protocol.Packet && (type = InternalBytebufHandler.this.toEnumType((nmsPacket = (net.minecraft.network.protocol.Packet)msg).type())) != null) {
                try {
                    msg = InternalBytebufHandler.this.callPacketOutEvent(this.player, InternalBytebufHandler.this.createBytebufPacket(type, nmsPacket));
                }
                catch (Exception e) {
                    MinecraftServer.LOGGER.error("Error on PacketInEvent.", (Throwable)e);
                }
            }
            if (msg != null) {
                super.write(ctx, (Object)msg, promise);
            }
        }
    }
}

