/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.command.subcommands;

import io.papermc.paper.command.CommandUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.DyeColor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.leavesmc.leaves.LeavesConfig;
import org.leavesmc.leaves.command.LeavesSubcommand;
import org.leavesmc.leaves.util.HopperCounter;

public class CounterCommand
implements LeavesSubcommand {
    @Override
    public boolean execute(CommandSender sender, String subCommand, String[] args) {
        if (!LeavesConfig.hopperCounter) {
            return false;
        }
        if (args.length < 1) {
            sender.sendMessage(Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{Component.text((String)"Hopper Counter: ", (TextColor)NamedTextColor.GRAY), Component.text((boolean)HopperCounter.isEnabled(), (TextColor)(HopperCounter.isEnabled() ? NamedTextColor.AQUA : NamedTextColor.GRAY))}));
            return true;
        }
        if (!HopperCounter.isEnabled()) {
            if (args[0].equals("enable")) {
                HopperCounter.setEnabled(true);
                sender.sendMessage((Component)Component.text((String)"Hopper Counter now is enabled", (TextColor)NamedTextColor.AQUA));
            } else {
                sender.sendMessage((Component)Component.text((String)"Hopper Counter is not enabled", (TextColor)NamedTextColor.RED));
            }
            return true;
        }
        DyeColor color = DyeColor.byName(args[0], null);
        if (color != null) {
            HopperCounter counter = HopperCounter.getCounter(color);
            if (args.length < 2) {
                this.displayCounter(sender, counter, false);
            } else {
                switch (args[1]) {
                    case "reset": {
                        counter.reset(MinecraftServer.getServer());
                        sender.sendMessage(Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{Component.text((String)"Restarted "), Component.text((String)color.getName(), (TextColor)TextColor.color((int)color.getTextColor())), Component.text((String)" counter")}));
                        break;
                    }
                    case "realtime": {
                        this.displayCounter(sender, counter, true);
                    }
                }
            }
            return true;
        }
        switch (args[0]) {
            case "reset": {
                HopperCounter.resetAll(MinecraftServer.getServer(), false);
                sender.sendMessage((Component)Component.text((String)"Restarted all counters"));
                break;
            }
            case "disable": {
                HopperCounter.setEnabled(false);
                HopperCounter.resetAll(MinecraftServer.getServer(), true);
                sender.sendMessage((Component)Component.text((String)"Hopper Counter now is disabled", (TextColor)NamedTextColor.GRAY));
            }
        }
        return true;
    }

    private void displayCounter(CommandSender sender, @NotNull HopperCounter counter, boolean realTime) {
        for (Component component : counter.format(MinecraftServer.getServer(), realTime)) {
            sender.sendMessage(component);
        }
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String subCommand, String[] args) {
        if (!LeavesConfig.hopperCounter) {
            return Collections.emptyList();
        }
        switch (args.length) {
            case 1: {
                if (!HopperCounter.isEnabled()) {
                    return Collections.singletonList("enable");
                }
                ArrayList<String> list = new ArrayList<String>(Arrays.stream(DyeColor.values()).map(DyeColor::getName).toList());
                list.add("reset");
                list.add("disable");
                return CommandUtil.getListMatchingLast(sender, args, list);
            }
            case 2: {
                if (DyeColor.byName(args[0], null) == null) break;
                return CommandUtil.getListMatchingLast(sender, args, "reset", "realtime");
            }
        }
        return Collections.emptyList();
    }

    @Override
    public boolean tabCompletes() {
        return LeavesConfig.hopperCounter;
    }
}

