/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.command.subcommands;

import io.papermc.paper.command.CommandUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.NaturalSpawner;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;
import org.leavesmc.leaves.command.LeavesSubcommand;

public class PeacefulModeSwitchCommand
implements LeavesSubcommand {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean execute(CommandSender sender, String subCommand, String[] args) {
        World world;
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage((Component)Component.text((String)"Must specify a world! ex: '/leaves peaceful world'", (TextColor)NamedTextColor.RED));
                return true;
            }
            Player player = (Player)sender;
            world = player.getWorld();
        } else {
            String input = args[0];
            World inputWorld = Bukkit.getWorld((String)input);
            if (inputWorld == null) {
                sender.sendMessage((Component)Component.text((String)("'" + input + "' is not a valid world!"), (TextColor)NamedTextColor.RED));
                return true;
            }
            world = inputWorld;
        }
        ServerLevel level = ((CraftWorld)world).getHandle();
        int chunks = 0;
        if (level.chunkSource.getLastSpawnState() != null) {
            chunks = level.chunkSource.getLastSpawnState().getSpawnableChunkCount();
        }
        sender.sendMessage(Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{Component.text((String)"Peaceful Mode Switch for world: "), Component.text((String)world.getName(), (TextColor)NamedTextColor.AQUA)}));
        sender.sendMessage(Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{Component.text((String)"Refuses per "), Component.text((int)level.chunkSource.peacefulModeSwitchTick, (TextColor)(level.chunkSource.peacefulModeSwitchTick > 0 ? NamedTextColor.AQUA : NamedTextColor.GRAY)), Component.text((String)" tick")}));
        int count = level.chunkSource.peacefulModeSwitchCount;
        int limit = NaturalSpawner.globalLimitForCategory(level, MobCategory.MONSTER, chunks);
        NamedTextColor color = count >= limit ? NamedTextColor.AQUA : NamedTextColor.GRAY;
        sender.sendMessage(Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{Component.text((String)"Now count "), Component.text((int)count, (TextColor)color), Component.text((String)"/", (TextColor)color), Component.text((int)limit, (TextColor)color)}));
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String subCommand, String[] args) {
        return CommandUtil.getListMatchingLast(sender, args, this.suggestPeacefulModeSwitch(args));
    }

    private List<String> suggestPeacefulModeSwitch(String[] args) {
        if (args.length == 1) {
            return new ArrayList<String>(Bukkit.getWorlds().stream().map(WorldInfo::getName).toList());
        }
        return Collections.emptyList();
    }
}

