/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.config;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.leavesmc.leaves.config.ConfigConvert;

public interface ConfigVerify<E>
extends ConfigConvert<E> {
    default public String check(E old, E value) {
        return null;
    }

    default public List<String> valueSuggest() {
        return List.of("<value>");
    }

    default public void runAfterLoader(E value) {
    }

    public static class EnumConfigVerify<E extends Enum<E>>
    implements ConfigVerify<Enum<E>> {
        private final Class<E> enumClass;
        private final List<String> enumValues;

        public EnumConfigVerify() {
            Type genericSuperclass = this.getClass().getGenericSuperclass();
            Type[] typeArguments = ((ParameterizedType)genericSuperclass).getActualTypeArguments();
            this.enumClass = (Class)typeArguments[0];
            this.enumValues = new ArrayList<String>(){
                {
                    for (Enum e : (Enum[])enumClass.getEnumConstants()) {
                        this.add(e.name().toLowerCase(Locale.ROOT));
                    }
                }
            };
        }

        @Override
        public Enum<E> convert(String value) {
            return Enum.valueOf(this.enumClass, value.toUpperCase(Locale.ROOT));
        }

        @Override
        public List<String> valueSuggest() {
            return this.enumValues;
        }
    }

    public static class ListConfigVerify
    implements ConfigVerify<List<?>> {
        @Override
        public List<?> convert(String value) {
            throw new IllegalArgumentException("not support");
        }
    }

    public static class DoubleConfigVerify
    implements ConfigVerify<Double> {
        @Override
        public Double convert(String value) {
            return Double.parseDouble(value);
        }
    }

    public static class StringConfigVerify
    implements ConfigVerify<String> {
        @Override
        public String convert(String value) {
            return value;
        }
    }

    public static class IntConfigVerify
    implements ConfigVerify<Integer> {
        @Override
        public Integer convert(String value) {
            return Integer.parseInt(value);
        }
    }

    public static class BooleanConfigVerify
    implements ConfigVerify<Boolean> {
        @Override
        public Boolean convert(String value) {
            return Boolean.parseBoolean(value);
        }

        @Override
        public List<String> valueSuggest() {
            return List.of("false", "true");
        }
    }
}

