/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.entity;

import java.util.UUID;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.leavesmc.leaves.bot.ServerBot;
import org.leavesmc.leaves.bot.agent.Actions;
import org.leavesmc.leaves.bot.agent.BotAction;
import org.leavesmc.leaves.entity.Bot;
import org.leavesmc.leaves.entity.botaction.LeavesBotAction;

public class CraftBot
extends CraftPlayer
implements Bot {
    public CraftBot(CraftServer server, ServerBot entity) {
        super(server, entity);
    }

    public String getSkinName() {
        return this.getHandle().createState.skinName;
    }

    @NotNull
    public String getRealName() {
        return this.getHandle().createState.getRealName();
    }

    @Nullable
    public UUID getCreatePlayerUUID() {
        return this.getHandle().createPlayer;
    }

    public boolean setBotAction(@NotNull String action, @NotNull Player player, @NotNull String[] args) {
        BotAction newAction;
        BotAction botAction = Actions.getForName(action);
        if (botAction != null && (newAction = botAction.getNew(((CraftPlayer)player).getHandle(), botAction.getArgument().parse(0, args))) != null) {
            this.getHandle().setBotAction(newAction);
            return true;
        }
        return false;
    }

    public boolean setBotAction(@NotNull LeavesBotAction action, @NotNull Player player, @NotNull String[] args) {
        return this.setBotAction(action.getName(), player, args);
    }

    @Override
    public ServerBot getHandle() {
        return (ServerBot)this.entity;
    }

    public void setHandle(ServerBot entity) {
        super.setHandle(entity);
    }

    @Override
    public String toString() {
        return "CraftBot{name=" + this.getName() + "}";
    }
}

