/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.entity;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.leavesmc.leaves.entity.Photographer;
import org.leavesmc.leaves.entity.PhotographerManager;
import org.leavesmc.leaves.replay.BukkitRecorderOption;
import org.leavesmc.leaves.replay.RecorderOption;
import org.leavesmc.leaves.replay.ServerPhotographer;

public class CraftPhotographerManager
implements PhotographerManager {
    private final Collection<Photographer> photographerViews = Collections.unmodifiableList(Lists.transform(ServerPhotographer.getPhotographers(), ServerPhotographer::getBukkitPlayer));

    @Nullable
    public Photographer getPhotographer(@NotNull UUID uuid) {
        ServerPhotographer photographer = ServerPhotographer.getPhotographer(uuid);
        if (photographer != null) {
            return photographer.getBukkitPlayer();
        }
        return null;
    }

    @Nullable
    public Photographer getPhotographer(@NotNull String id) {
        ServerPhotographer photographer = ServerPhotographer.getPhotographer(id);
        if (photographer != null) {
            return photographer.getBukkitPlayer();
        }
        return null;
    }

    @Nullable
    public Photographer createPhotographer(@NotNull String id, @NotNull Location location) {
        ServerPhotographer photographer = new ServerPhotographer.PhotographerCreateState(location, id, RecorderOption.createDefaultOption()).createSync();
        if (photographer != null) {
            return photographer.getBukkitPlayer();
        }
        return null;
    }

    @Nullable
    public Photographer createPhotographer(@NotNull String id, @NotNull Location location, @NotNull BukkitRecorderOption recorderOption) {
        ServerPhotographer photographer = new ServerPhotographer.PhotographerCreateState(location, id, RecorderOption.createFromBukkit(recorderOption)).createSync();
        if (photographer != null) {
            return photographer.getBukkitPlayer();
        }
        return null;
    }

    public void removePhotographer(@NotNull String id) {
        ServerPhotographer photographer = ServerPhotographer.getPhotographer(id);
        if (photographer != null) {
            photographer.remove(true);
        }
    }

    public void removePhotographer(@NotNull UUID uuid) {
        ServerPhotographer photographer = ServerPhotographer.getPhotographer(uuid);
        if (photographer != null) {
            photographer.remove(true);
        }
    }

    public void removeAllPhotographers() {
        for (ServerPhotographer photographer : ServerPhotographer.getPhotographers()) {
            photographer.remove(true);
        }
    }

    public Collection<Photographer> getPhotographers() {
        return this.photographerViews;
    }
}

