/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.food.FoodData;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.leavesmc.leaves.LeavesConfig;
import org.leavesmc.leaves.protocol.core.LeavesProtocol;
import org.leavesmc.leaves.protocol.core.ProtocolHandler;
import org.leavesmc.leaves.protocol.core.ProtocolUtils;

@LeavesProtocol(namespace={"appleskin"})
public class AppleSkinProtocol {
    public static final String PROTOCOL_ID = "appleskin";
    private static final ResourceLocation SATURATION_KEY = AppleSkinProtocol.id("saturation_sync");
    private static final ResourceLocation EXHAUSTION_KEY = AppleSkinProtocol.id("exhaustion_sync");
    private static final Map<UUID, Float> previousSaturationLevels = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> previousExhaustionLevels = new HashMap<UUID, Float>();
    private static final float MINIMUM_EXHAUSTION_CHANGE_THRESHOLD = 0.01f;
    private static final Set<ServerPlayer> players = new HashSet<ServerPlayer>();

    @Contract(value="_ -> new")
    @NotNull
    public static ResourceLocation id(String path) {
        return new ResourceLocation(PROTOCOL_ID, path);
    }

    @ProtocolHandler.PlayerJoin
    public static void onPlayerLoggedIn(@NotNull ServerPlayer player) {
        if (LeavesConfig.appleskinProtocol) {
            AppleSkinProtocol.resetPlayerData(player);
        }
    }

    @ProtocolHandler.PlayerLeave
    public static void onPlayerLoggedOut(@NotNull ServerPlayer player) {
        if (LeavesConfig.appleskinProtocol) {
            players.remove(player);
            AppleSkinProtocol.resetPlayerData(player);
        }
    }

    @ProtocolHandler.MinecraftRegister(ignoreId=true)
    public static void onPlayerSubscribed(@NotNull ServerPlayer player) {
        if (LeavesConfig.appleskinProtocol) {
            players.add(player);
        }
    }

    @ProtocolHandler.Ticker
    public static void tick() {
        if (LeavesConfig.appleskinProtocol) {
            for (ServerPlayer player : players) {
                FoodData data = player.getFoodData();
                float saturation = data.getSaturationLevel();
                Float previousSaturation = previousSaturationLevels.get(player.getUUID());
                if (previousSaturation == null || saturation != previousSaturation.floatValue()) {
                    ProtocolUtils.sendPayloadPacket(player, SATURATION_KEY, buf -> buf.writeFloat(saturation));
                    previousSaturationLevels.put(player.getUUID(), Float.valueOf(saturation));
                }
                float exhaustion = data.getExhaustionLevel();
                Float previousExhaustion = previousExhaustionLevels.get(player.getUUID());
                if (previousExhaustion != null && !(Math.abs(exhaustion - previousExhaustion.floatValue()) >= 0.01f)) continue;
                ProtocolUtils.sendPayloadPacket(player, EXHAUSTION_KEY, buf -> buf.writeFloat(exhaustion));
                previousExhaustionLevels.put(player.getUUID(), Float.valueOf(exhaustion));
            }
        }
    }

    @ProtocolHandler.ReloadServer
    public static void onServerReload() {
        if (!LeavesConfig.appleskinProtocol) {
            AppleSkinProtocol.disableAllPlayer();
        }
    }

    public static void disableAllPlayer() {
        for (ServerPlayer player : MinecraftServer.getServer().getPlayerList().getPlayers()) {
            AppleSkinProtocol.onPlayerLoggedOut(player);
        }
    }

    private static void resetPlayerData(@NotNull ServerPlayer player) {
        previousExhaustionLevels.remove(player.getUUID());
        previousSaturationLevels.remove(player.getUUID());
    }
}

