/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.leavesmc.leaves.LeavesConfig;
import org.leavesmc.leaves.LeavesLogger;
import org.leavesmc.leaves.protocol.core.LeavesCustomPayload;
import org.leavesmc.leaves.protocol.core.LeavesProtocol;
import org.leavesmc.leaves.protocol.core.ProtocolHandler;
import org.leavesmc.leaves.protocol.core.ProtocolUtils;

@LeavesProtocol(namespace={"carpet"})
public class CarpetServerProtocol {
    public static final String PROTOCOL_ID = "carpet";
    public static final String VERSION = "leaves-carpet-1.0.0";
    private static final ResourceLocation HELLO_ID = CarpetServerProtocol.id("hello");
    private static final String HI = "69";
    private static final String HELLO = "420";

    @Contract(value="_ -> new")
    @NotNull
    public static ResourceLocation id(String path) {
        return new ResourceLocation(PROTOCOL_ID, path);
    }

    @ProtocolHandler.PlayerJoin
    public static void onPlayerJoin(ServerPlayer player) {
        if (LeavesConfig.leavesCarpetSupport) {
            CompoundTag data = new CompoundTag();
            data.putString(HI, VERSION);
            ProtocolUtils.sendPayloadPacket(player, new CarpetPayload(data));
        }
    }

    @ProtocolHandler.PayloadReceiver(payload=CarpetPayload.class, payloadId={"hello"})
    private static void handleHello(@NotNull ServerPlayer player, @NotNull CarpetPayload payload) {
        if (LeavesConfig.leavesCarpetSupport && payload.nbt.contains(HELLO)) {
            LeavesLogger.LOGGER.info("Player " + player.getScoreboardName() + " joined with carpet " + payload.nbt.getString(HELLO));
            CompoundTag data = new CompoundTag();
            CarpetRules.write(data);
            ProtocolUtils.sendPayloadPacket(player, new CarpetPayload(data));
        }
    }

    public record CarpetPayload(CompoundTag nbt) implements LeavesCustomPayload<CarpetPayload>
    {
        @LeavesCustomPayload.New
        public CarpetPayload(ResourceLocation location, FriendlyByteBuf buf) {
            this(buf.readNbt());
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.writeNbt(this.nbt);
        }

        @Override
        @NotNull
        public ResourceLocation id() {
            return HELLO_ID;
        }
    }

    public static class CarpetRules {
        private static final Map<String, CarpetRule> rules = new HashMap<String, CarpetRule>();

        public static void write(@NotNull CompoundTag tag) {
            CompoundTag rulesNbt = new CompoundTag();
            rules.values().forEach(rule -> rule.writeNBT(rulesNbt));
            tag.put("Rules", rulesNbt);
        }

        public static void register(CarpetRule rule) {
            rules.put(rule.name, rule);
        }
    }

    public record CarpetRule(String identifier, String name, String value) {
        @NotNull
        @Contract(value="_, _, _ -> new")
        public static CarpetRule of(String identifier, String name, Enum<?> value) {
            return new CarpetRule(identifier, name, value.name().toLowerCase(Locale.ROOT));
        }

        @NotNull
        @Contract(value="_, _, _ -> new")
        public static CarpetRule of(String identifier, String name, boolean value) {
            return new CarpetRule(identifier, name, Boolean.toString(value));
        }

        public void writeNBT(@NotNull CompoundTag rules) {
            CompoundTag rule = new CompoundTag();
            Object key = this.name;
            while (rules.contains((String)key)) {
                key = (String)key + "2";
            }
            rule.putString("Value", this.value);
            rule.putString("Manager", this.identifier);
            rule.putString("Rule", this.name);
            rules.put((String)key, rule);
        }
    }
}

