/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.Vec3;
import org.leavesmc.leaves.LeavesLogger;
import org.leavesmc.leaves.util.MathUtils;

public class LitematicaEasyPlaceProtocol {
    public static final ImmutableSet<Property<?>> WHITELISTED_PROPERTIES = ImmutableSet.of((Object)BlockStateProperties.INVERTED, (Object)BlockStateProperties.OPEN, (Object)BlockStateProperties.PERSISTENT, BlockStateProperties.AXIS, BlockStateProperties.HALF, BlockStateProperties.CHEST_TYPE, (Object[])new Property[]{BlockStateProperties.MODE_COMPARATOR, BlockStateProperties.DOOR_HINGE, BlockStateProperties.SLAB_TYPE, BlockStateProperties.STAIRS_SHAPE, BlockStateProperties.ATTACH_FACE, BlockStateProperties.BITES, BlockStateProperties.DELAY, BlockStateProperties.NOTE, BlockStateProperties.ROTATION_16});

    public static <T extends Comparable<T>> BlockState applyPlacementProtocol(BlockState state, BlockPlaceContext context) {
        return LitematicaEasyPlaceProtocol.applyPlacementProtocolV3(state, UseContext.from(context, context.getHand()));
    }

    private static <T extends Comparable<T>> BlockState applyPlacementProtocolV3(BlockState state, UseContext context) {
        int protocolValue = (int)(context.getHitVec().x - (double)context.getPos().getX()) - 2;
        if (protocolValue < 0) {
            return state;
        }
        DirectionProperty property = LitematicaEasyPlaceProtocol.getFirstDirectionProperty(state);
        if (property != null && property != BlockStateProperties.VERTICAL_DIRECTION) {
            if ((state = LitematicaEasyPlaceProtocol.applyDirectionProperty(state, context, property, protocolValue)) == null) {
                return null;
            }
            protocolValue >>>= 3;
        }
        protocolValue >>>= 1;
        ArrayList propList = new ArrayList(state.getBlock().getStateDefinition().getProperties());
        propList.sort(Comparator.comparing(Property::getName));
        try {
            for (Property property2 : propList) {
                if (property2 instanceof DirectionProperty || !WHITELISTED_PROPERTIES.contains((Object)property2)) continue;
                Property prop = property2;
                ArrayList list = new ArrayList(prop.getPossibleValues());
                list.sort(Comparable::compareTo);
                int requiredBits = MathUtils.floorLog2(MathUtils.smallestEncompassingPowerOfTwo(list.size()));
                int bitMask = ~(-1 << requiredBits);
                int valueIndex = protocolValue & bitMask;
                if (valueIndex < 0 || valueIndex >= list.size()) continue;
                Comparable value = (Comparable)list.get(valueIndex);
                if (!state.getValue(prop).equals(value) && value != SlabType.DOUBLE) {
                    state = (BlockState)state.setValue(prop, value);
                }
                protocolValue >>>= requiredBits;
            }
        }
        catch (Exception e) {
            LeavesLogger.LOGGER.warning("Exception trying to apply placement protocol value");
        }
        return state;
    }

    private static BlockState applyDirectionProperty(BlockState state, UseContext context, DirectionProperty property, int protocolValue) {
        Direction facingOrig;
        Direction facing = facingOrig = state.getValue(property);
        int decodedFacingIndex = (protocolValue & 0xF) >> 1;
        if (decodedFacingIndex == 6) {
            facing = facing.getOpposite();
        } else if (decodedFacingIndex >= 0 && decodedFacingIndex <= 5) {
            facing = Direction.from3DDataValue(decodedFacingIndex);
            if (!property.getPossibleValues().contains(facing)) {
                facing = context.getEntity().getDirection().getOpposite();
            }
        }
        if (facing != facingOrig && property.getPossibleValues().contains(facing)) {
            if (state.getBlock() instanceof BedBlock) {
                BlockPos headPos = context.pos.relative(facing);
                BlockPlaceContext ctx = context.getItemPlacementContext();
                if (ctx == null || !context.getWorld().getBlockState(headPos).canBeReplaced(ctx)) {
                    return null;
                }
            }
            state = (BlockState)state.setValue(property, facing);
        }
        return state;
    }

    private static DirectionProperty getFirstDirectionProperty(BlockState state) {
        for (Property<?> prop : state.getProperties()) {
            if (!(prop instanceof DirectionProperty)) continue;
            return (DirectionProperty)prop;
        }
        return null;
    }

    public static class UseContext {
        private final Level world;
        private final BlockPos pos;
        private final Direction side;
        private final Vec3 hitVec;
        private final LivingEntity entity;
        private final InteractionHand hand;
        @Nullable
        private final BlockPlaceContext itemPlacementContext;

        private UseContext(Level world, BlockPos pos, Direction side, Vec3 hitVec, LivingEntity entity, InteractionHand hand, @Nullable BlockPlaceContext itemPlacementContext) {
            this.world = world;
            this.pos = pos;
            this.side = side;
            this.hitVec = hitVec;
            this.entity = entity;
            this.hand = hand;
            this.itemPlacementContext = itemPlacementContext;
        }

        public static UseContext from(BlockPlaceContext ctx, InteractionHand hand) {
            Vec3 pos = ctx.getClickLocation();
            return new UseContext(ctx.getLevel(), ctx.getClickedPos(), ctx.getClickedFace(), new Vec3(pos.x, pos.y, pos.z), ctx.getPlayer(), hand, ctx);
        }

        public Level getWorld() {
            return this.world;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public Direction getSide() {
            return this.side;
        }

        public Vec3 getHitVec() {
            return this.hitVec;
        }

        public LivingEntity getEntity() {
            return this.entity;
        }

        public InteractionHand getHand() {
            return this.hand;
        }

        @Nullable
        public BlockPlaceContext getItemPlacementContext() {
            return this.itemPlacementContext;
        }
    }
}

