/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.leavesmc.leaves.LeavesConfig;
import org.leavesmc.leaves.protocol.core.LeavesProtocol;
import org.leavesmc.leaves.protocol.core.ProtocolUtils;

@LeavesProtocol(namespace={"xaerominimap", "xaeroworldmap"})
public class XaeroMapProtocol {
    public static final String PROTOCOL_ID_MINI = "xaerominimap";
    public static final String PROTOCOL_ID_WORLD = "xaeroworldmap";
    private static final ResourceLocation MINIMAP_KEY = XaeroMapProtocol.idMini("main");
    private static final ResourceLocation WORLDMAP_KEY = XaeroMapProtocol.idWorld("main");

    @Contract(value="_ -> new")
    @NotNull
    public static ResourceLocation idMini(String path) {
        return new ResourceLocation(PROTOCOL_ID_MINI, path);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ResourceLocation idWorld(String path) {
        return new ResourceLocation(PROTOCOL_ID_WORLD, path);
    }

    public static void onSendWorldInfo(@NotNull ServerPlayer player) {
        if (LeavesConfig.xaeroMapProtocol) {
            ProtocolUtils.sendPayloadPacket(player, MINIMAP_KEY, buf -> {
                buf.writeByte(0);
                buf.writeInt(LeavesConfig.xaeroMapServerID);
            });
            ProtocolUtils.sendPayloadPacket(player, WORLDMAP_KEY, buf -> {
                buf.writeByte(0);
                buf.writeInt(LeavesConfig.xaeroMapServerID);
            });
        }
    }
}

