/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol.core;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.event.player.PlayerKickEvent;
import org.jetbrains.annotations.NotNull;
import org.leavesmc.leaves.LeavesLogger;
import org.leavesmc.leaves.protocol.core.LeavesCustomPayload;
import org.leavesmc.leaves.protocol.core.LeavesProtocol;
import org.leavesmc.leaves.protocol.core.ProtocolHandler;

public class LeavesProtocolManager {
    private static final LeavesLogger LOGGER = LeavesLogger.LOGGER;
    private static final Map<LeavesProtocol, Map<ProtocolHandler.PayloadReceiver, Constructor<? extends LeavesCustomPayload<?>>>> KNOWN_TYPES = new HashMap();
    private static final Map<LeavesProtocol, Map<ProtocolHandler.PayloadReceiver, Method>> KNOW_RECEIVERS = new HashMap<LeavesProtocol, Map<ProtocolHandler.PayloadReceiver, Method>>();
    private static final List<Method> TICKERS = new ArrayList<Method>();
    private static final List<Method> PLAYER_JOIN = new ArrayList<Method>();
    private static final List<Method> PLAYER_LEAVE = new ArrayList<Method>();
    private static final List<Method> RELOAD_SERVER = new ArrayList<Method>();
    private static final Map<LeavesProtocol, Map<ProtocolHandler.MinecraftRegister, Method>> MINECRAFT_REGISTER = new HashMap<LeavesProtocol, Map<ProtocolHandler.MinecraftRegister, Method>>();

    public static void init() {
        for (Class<?> clazz : LeavesProtocolManager.getClasses("org.leavesmc.leaves.protocol")) {
            HashSet methods;
            LeavesProtocol protocol = clazz.getAnnotation(LeavesProtocol.class);
            if (protocol == null) continue;
            try {
                Method[] publicMethods = clazz.getMethods();
                Method[] privateMethods = clazz.getDeclaredMethods();
                methods = new HashSet(publicMethods.length + privateMethods.length, 1.0f);
                Collections.addAll(methods, publicMethods);
                Collections.addAll(methods, privateMethods);
            }
            catch (NoClassDefFoundError error) {
                LOGGER.severe("Failed to load class " + clazz.getName() + " due to missing dependencies, " + String.valueOf(error.getCause()) + ": " + error.getMessage());
                return;
            }
            Map map = KNOWN_TYPES.getOrDefault(protocol, new HashMap());
            for (Method method : methods) {
                if (method.isBridge() || method.isSynthetic() || !Modifier.isStatic(method.getModifiers())) continue;
                method.setAccessible(true);
                ProtocolHandler.Init init = method.getAnnotation(ProtocolHandler.Init.class);
                if (init != null) {
                    try {
                        method.invoke(null, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException exception) {
                        LOGGER.severe("Failed to invoke init method " + method.getName() + " in " + clazz.getName() + ", " + String.valueOf(exception.getCause()) + ": " + exception.getMessage());
                    }
                    continue;
                }
                ProtocolHandler.PayloadReceiver receiver = method.getAnnotation(ProtocolHandler.PayloadReceiver.class);
                if (receiver != null) {
                    try {
                        Constructor<LeavesCustomPayload<?>> constructor = receiver.payload().getConstructor(ResourceLocation.class, FriendlyByteBuf.class);
                        constructor.setAccessible(true);
                        if (constructor.getAnnotation(LeavesCustomPayload.New.class) == null) {
                            LOGGER.warning("Failed to find new annotation for " + receiver.payload().getName());
                        }
                        map.put(receiver, constructor);
                    }
                    catch (NoSuchMethodException exception) {
                        LOGGER.severe("Failed to find constructor for " + receiver.payload().getName() + ", " + String.valueOf(exception.getCause()) + ": " + exception.getMessage());
                        continue;
                    }
                    if (!KNOW_RECEIVERS.containsKey(protocol)) {
                        KNOW_RECEIVERS.put(protocol, new HashMap());
                    }
                    KNOW_RECEIVERS.get(protocol).put(receiver, method);
                    continue;
                }
                ProtocolHandler.Ticker ticker = method.getAnnotation(ProtocolHandler.Ticker.class);
                if (ticker != null) {
                    TICKERS.add(method);
                    continue;
                }
                ProtocolHandler.PlayerJoin playerJoin = method.getAnnotation(ProtocolHandler.PlayerJoin.class);
                if (playerJoin != null) {
                    PLAYER_JOIN.add(method);
                    continue;
                }
                ProtocolHandler.PlayerLeave playerLeave = method.getAnnotation(ProtocolHandler.PlayerLeave.class);
                if (playerLeave != null) {
                    PLAYER_LEAVE.add(method);
                    continue;
                }
                ProtocolHandler.ReloadServer reloadServer = method.getAnnotation(ProtocolHandler.ReloadServer.class);
                if (reloadServer != null) {
                    RELOAD_SERVER.add(method);
                    continue;
                }
                ProtocolHandler.MinecraftRegister minecraftRegister = method.getAnnotation(ProtocolHandler.MinecraftRegister.class);
                if (minecraftRegister == null) continue;
                if (!MINECRAFT_REGISTER.containsKey(protocol)) {
                    MINECRAFT_REGISTER.put(protocol, new HashMap());
                }
                MINECRAFT_REGISTER.get(protocol).put(minecraftRegister, method);
            }
            KNOWN_TYPES.put(protocol, map);
        }
    }

    public static LeavesCustomPayload<?> decode(ResourceLocation id, FriendlyByteBuf buf) {
        for (LeavesProtocol protocol : KNOWN_TYPES.keySet()) {
            if (!ArrayUtils.contains((Object[])protocol.namespace(), (Object)id.getNamespace())) continue;
            Map<ProtocolHandler.PayloadReceiver, Constructor<LeavesCustomPayload<?>>> map = KNOWN_TYPES.get(protocol);
            for (ProtocolHandler.PayloadReceiver receiver : map.keySet()) {
                if (!receiver.ignoreId() && !ArrayUtils.contains((Object[])receiver.payloadId(), (Object)id.getPath())) continue;
                try {
                    return map.get(receiver).newInstance(new Object[]{id, buf});
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException exception) {
                    LOGGER.warning("Failed to create payload for " + String.valueOf(id) + " in " + ArrayUtils.toString((Object)protocol.namespace()) + ", " + String.valueOf(exception.getCause()) + ": " + exception.getMessage());
                    buf.readBytes(buf.readableBytes());
                    return new ErrorPayload(id, protocol.namespace(), receiver.payloadId());
                }
            }
        }
        return null;
    }

    public static void handlePayload(ServerPlayer player, LeavesCustomPayload<?> payload) {
        if (payload instanceof ErrorPayload) {
            ErrorPayload errorPayload = (ErrorPayload)payload;
            player.connection.disconnect("Payload " + Arrays.toString(errorPayload.packetID) + " from " + Arrays.toString(errorPayload.protocolID) + " error", PlayerKickEvent.Cause.INVALID_PAYLOAD);
            return;
        }
        for (LeavesProtocol protocol : KNOW_RECEIVERS.keySet()) {
            if (!ArrayUtils.contains((Object[])protocol.namespace(), (Object)payload.type().id().getNamespace())) continue;
            Map<ProtocolHandler.PayloadReceiver, Method> map = KNOW_RECEIVERS.get(protocol);
            for (ProtocolHandler.PayloadReceiver receiver : map.keySet()) {
                if (payload.getClass() != receiver.payload() || !receiver.ignoreId() && !ArrayUtils.contains((Object[])receiver.payloadId(), (Object)payload.type().id().getPath())) continue;
                try {
                    map.get(receiver).invoke(null, player, payload);
                }
                catch (IllegalAccessException | InvocationTargetException exception) {
                    LOGGER.warning("Failed to handle payload " + String.valueOf(payload.type().id()) + " in " + ArrayUtils.toString((Object)protocol.namespace()) + ", " + String.valueOf(exception.getCause()) + ": " + exception.getMessage());
                }
            }
        }
    }

    public static void handleTick() {
        if (!TICKERS.isEmpty()) {
            try {
                for (Method method : TICKERS) {
                    method.invoke(null, new Object[0]);
                }
            }
            catch (IllegalAccessException | InvocationTargetException exception) {
                LOGGER.warning("Failed to tick, " + String.valueOf(exception.getCause()) + ": " + exception.getMessage());
            }
        }
    }

    public static void handlePlayerJoin(ServerPlayer player) {
        if (!PLAYER_JOIN.isEmpty()) {
            try {
                for (Method method : PLAYER_JOIN) {
                    method.invoke(null, player);
                }
            }
            catch (IllegalAccessException | InvocationTargetException exception) {
                LOGGER.warning("Failed to handle player join, " + String.valueOf(exception.getCause()) + ": " + exception.getMessage());
            }
        }
    }

    public static void handlePlayerLeave(ServerPlayer player) {
        if (!PLAYER_LEAVE.isEmpty()) {
            try {
                for (Method method : PLAYER_LEAVE) {
                    method.invoke(null, player);
                }
            }
            catch (IllegalAccessException | InvocationTargetException exception) {
                LOGGER.warning("Failed to handle player leave, " + String.valueOf(exception.getCause()) + ": " + exception.getMessage());
            }
        }
    }

    public static void handleServerReload() {
        if (!RELOAD_SERVER.isEmpty()) {
            try {
                for (Method method : RELOAD_SERVER) {
                    method.invoke(null, new Object[0]);
                }
            }
            catch (IllegalAccessException | InvocationTargetException exception) {
                LOGGER.warning("Failed to handle server reload, " + String.valueOf(exception.getCause()) + ": " + exception.getMessage());
            }
        }
    }

    public static void handleMinecraftRegister(String channelId, ServerPlayer player) {
        for (LeavesProtocol protocol : MINECRAFT_REGISTER.keySet()) {
            String[] channel = channelId.split(":");
            if (!ArrayUtils.contains((Object[])protocol.namespace(), (Object)channel[0])) continue;
            Map<ProtocolHandler.MinecraftRegister, Method> map = MINECRAFT_REGISTER.get(protocol);
            for (ProtocolHandler.MinecraftRegister register : map.keySet()) {
                if (!register.ignoreId() && !register.channelId().equals(channel[1]) && !ArrayUtils.contains((Object[])register.channelIds(), (Object)channel[1])) continue;
                try {
                    map.get(register).invoke(null, player);
                }
                catch (IllegalAccessException | InvocationTargetException exception) {
                    LOGGER.warning("Failed to handle minecraft register, " + String.valueOf(exception.getCause()) + ": " + exception.getMessage());
                }
            }
        }
    }

    public static Set<Class<?>> getClasses(String pack) {
        LinkedHashSet classes = new LinkedHashSet();
        String packageDirName = pack.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), StandardCharsets.UTF_8);
                    LeavesProtocolManager.findClassesInPackageByFile(pack, filePath, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    LeavesProtocolManager.findClassesInPackageByJar(pack, entries, packageDirName, classes);
                }
                catch (IOException exception) {
                    LOGGER.warning("Failed to load jar file, " + String.valueOf(exception.getCause()) + ": " + exception.getMessage());
                }
            }
        }
        catch (IOException exception) {
            LOGGER.warning("Failed to load classes, " + String.valueOf(exception.getCause()) + ": " + exception.getMessage());
        }
        return classes;
    }

    private static void findClassesInPackageByFile(String packageName, String packagePath, Set<Class<?>> classes) {
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] dirfiles = dir.listFiles(file -> file.isDirectory() || file.getName().endsWith(".class"));
        if (dirfiles != null) {
            for (File file2 : dirfiles) {
                if (file2.isDirectory()) {
                    LeavesProtocolManager.findClassesInPackageByFile(packageName + "." + file2.getName(), file2.getAbsolutePath(), classes);
                    continue;
                }
                String className = file2.getName().substring(0, file2.getName().length() - 6);
                try {
                    classes.add(Class.forName(packageName + "." + className));
                }
                catch (ClassNotFoundException exception) {
                    LOGGER.warning("Failed to load class " + className + ", " + String.valueOf(exception.getCause()) + ": " + exception.getMessage());
                }
            }
        }
    }

    private static void findClassesInPackageByJar(String packageName, Enumeration<JarEntry> entries, String packageDirName, Set<Class<?>> classes) {
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (name.charAt(0) == '/') {
                name = name.substring(1);
            }
            if (!name.startsWith(packageDirName)) continue;
            int idx = name.lastIndexOf(47);
            if (idx != -1) {
                packageName = name.substring(0, idx).replace('/', '.');
            }
            if (!name.endsWith(".class") || entry.isDirectory()) continue;
            String className = name.substring(packageName.length() + 1, name.length() - 6);
            try {
                classes.add(Class.forName(packageName + "." + className));
            }
            catch (ClassNotFoundException exception) {
                LOGGER.warning("Failed to load class " + className + ", " + String.valueOf(exception.getCause()) + ": " + exception.getMessage());
            }
        }
    }

    public record ErrorPayload(ResourceLocation id, String[] protocolID, String[] packetID) implements LeavesCustomPayload<ErrorPayload>
    {
        @Override
        public void write(@NotNull FriendlyByteBuf buf) {
        }
    }

    public record LeavesPayload(FriendlyByteBuf data, ResourceLocation id) implements LeavesCustomPayload<LeavesPayload>
    {
        @LeavesCustomPayload.New
        public LeavesPayload(ResourceLocation location, FriendlyByteBuf buf) {
            this(new FriendlyByteBuf(buf.readBytes(buf.readableBytes())), location);
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.writeBytes(this.data);
        }
    }

    public record EmptyPayload(ResourceLocation id) implements LeavesCustomPayload<EmptyPayload>
    {
        @LeavesCustomPayload.New
        public EmptyPayload(ResourceLocation location, FriendlyByteBuf buf) {
            this(location);
        }

        @Override
        public void write(@NotNull FriendlyByteBuf buf) {
        }
    }
}

