/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol.jade;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.CalibratedSculkSensorBlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.ComparatorBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.leavesmc.leaves.LeavesConfig;
import org.leavesmc.leaves.LeavesLogger;
import org.leavesmc.leaves.protocol.core.LeavesCustomPayload;
import org.leavesmc.leaves.protocol.core.LeavesProtocol;
import org.leavesmc.leaves.protocol.core.ProtocolHandler;
import org.leavesmc.leaves.protocol.core.ProtocolUtils;
import org.leavesmc.leaves.protocol.jade.accessor.BlockAccessor;
import org.leavesmc.leaves.protocol.jade.accessor.DataAccessor;
import org.leavesmc.leaves.protocol.jade.accessor.EntityAccessor;
import org.leavesmc.leaves.protocol.jade.provider.IJadeDataProvider;
import org.leavesmc.leaves.protocol.jade.provider.IJadeProvider;
import org.leavesmc.leaves.protocol.jade.provider.IServerExtensionProvider;
import org.leavesmc.leaves.protocol.jade.provider.ItemStorageExtensionProvider;
import org.leavesmc.leaves.protocol.jade.provider.block.BeehiveProvider;
import org.leavesmc.leaves.protocol.jade.provider.block.BlockStorageProvider;
import org.leavesmc.leaves.protocol.jade.provider.block.BrewingStandProvider;
import org.leavesmc.leaves.protocol.jade.provider.block.CampfireProvider;
import org.leavesmc.leaves.protocol.jade.provider.block.ChiseledBookshelfProvider;
import org.leavesmc.leaves.protocol.jade.provider.block.CommandBlockProvider;
import org.leavesmc.leaves.protocol.jade.provider.block.FurnaceProvider;
import org.leavesmc.leaves.protocol.jade.provider.block.JukeboxProvider;
import org.leavesmc.leaves.protocol.jade.provider.block.LecternProvider;
import org.leavesmc.leaves.protocol.jade.provider.block.MobSpawnerCooldownProvider;
import org.leavesmc.leaves.protocol.jade.provider.block.ObjectNameProvider;
import org.leavesmc.leaves.protocol.jade.provider.block.RedstoneProvider;
import org.leavesmc.leaves.protocol.jade.provider.entity.AnimalOwnerProvider;
import org.leavesmc.leaves.protocol.jade.provider.entity.EntityStorageProvider;
import org.leavesmc.leaves.protocol.jade.provider.entity.MobBreedingProvider;
import org.leavesmc.leaves.protocol.jade.provider.entity.MobGrowthProvider;
import org.leavesmc.leaves.protocol.jade.provider.entity.NextEntityDropProvider;
import org.leavesmc.leaves.protocol.jade.provider.entity.StatusEffectsProvider;
import org.leavesmc.leaves.protocol.jade.provider.entity.ZombieVillagerProvider;
import org.leavesmc.leaves.protocol.jade.util.HierarchyLookup;
import org.leavesmc.leaves.protocol.jade.util.PairHierarchyLookup;
import org.leavesmc.leaves.protocol.jade.util.PriorityStore;
import org.leavesmc.leaves.protocol.jade.util.WrappedHierarchyLookup;

@LeavesProtocol(namespace={"jade"})
public class JadeProtocol {
    public static PriorityStore<ResourceLocation, IJadeProvider> priorities;
    public static final String PROTOCOL_ID = "jade";
    public static final ResourceLocation PACKET_SERVER_PING;
    public static final ResourceLocation PACKET_RECEIVE_DATA;
    private static final HierarchyLookup<IJadeDataProvider<EntityAccessor>> entityDataProviders;
    private static final PairHierarchyLookup<IJadeDataProvider<BlockAccessor>> blockDataProviders;
    public static final WrappedHierarchyLookup<IServerExtensionProvider<ItemStack>> itemStorageProviders;

    @Contract(value="_ -> new")
    @NotNull
    public static ResourceLocation id(String path) {
        return new ResourceLocation(PROTOCOL_ID, path);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ResourceLocation mc_id(String path) {
        return new ResourceLocation(path);
    }

    private static boolean isPrimaryKey(ResourceLocation key) {
        return !key.getPath().contains(".");
    }

    private static ResourceLocation getPrimaryKey(ResourceLocation key) {
        return new ResourceLocation(key.getNamespace(), key.getPath().substring(0, key.getPath().indexOf(46)));
    }

    @ProtocolHandler.Init
    public static void init() {
        priorities = new PriorityStore<ResourceLocation, IJadeProvider>(IJadeProvider::getDefaultPriority, IJadeProvider::getUid);
        priorities.setSortingFunction((store, allKeys) -> {
            List keys = allKeys.stream().filter(JadeProtocol::isPrimaryKey).sorted(Comparator.comparingInt(store::byKey)).collect(Collectors.toCollection(ArrayList::new));
            allKeys.stream().filter(Predicate.not(JadeProtocol::isPrimaryKey)).forEach($ -> {
                int index = keys.indexOf(JadeProtocol.getPrimaryKey($));
                keys.add(index + 1, $);
            });
            return keys;
        });
        blockDataProviders.register(BlockEntity.class, ObjectNameProvider.INSTANCE);
        entityDataProviders.register(Entity.class, EntityStorageProvider.INSTANCE);
        blockDataProviders.register(Block.class, BlockStorageProvider.INSTANCE);
        itemStorageProviders.register(Object.class, ItemStorageExtensionProvider.INSTANCE);
        itemStorageProviders.register(Block.class, ItemStorageExtensionProvider.INSTANCE);
        entityDataProviders.register(Entity.class, AnimalOwnerProvider.INSTANCE);
        entityDataProviders.register(LivingEntity.class, StatusEffectsProvider.INSTANCE);
        entityDataProviders.register(AgeableMob.class, MobGrowthProvider.INSTANCE);
        entityDataProviders.register(Tadpole.class, MobGrowthProvider.INSTANCE);
        entityDataProviders.register(Animal.class, MobBreedingProvider.INSTANCE);
        entityDataProviders.register(Allay.class, MobBreedingProvider.INSTANCE);
        entityDataProviders.register(Chicken.class, NextEntityDropProvider.INSTANCE);
        entityDataProviders.register(Armadillo.class, NextEntityDropProvider.INSTANCE);
        entityDataProviders.register(ZombieVillager.class, ZombieVillagerProvider.INSTANCE);
        blockDataProviders.register(BrewingStandBlockEntity.class, BrewingStandProvider.INSTANCE);
        blockDataProviders.register(BeehiveBlockEntity.class, BeehiveProvider.INSTANCE);
        blockDataProviders.register(CommandBlockEntity.class, CommandBlockProvider.INSTANCE);
        blockDataProviders.register(JukeboxBlockEntity.class, JukeboxProvider.INSTANCE);
        blockDataProviders.register(LecternBlockEntity.class, LecternProvider.INSTANCE);
        blockDataProviders.register(ComparatorBlockEntity.class, RedstoneProvider.INSTANCE);
        blockDataProviders.register(HopperBlockEntity.class, RedstoneProvider.INSTANCE);
        blockDataProviders.register(CalibratedSculkSensorBlockEntity.class, RedstoneProvider.INSTANCE);
        blockDataProviders.register(AbstractFurnaceBlockEntity.class, FurnaceProvider.INSTANCE);
        blockDataProviders.register(ChiseledBookShelfBlockEntity.class, ChiseledBookshelfProvider.INSTANCE);
        blockDataProviders.register(TrialSpawnerBlockEntity.class, MobSpawnerCooldownProvider.INSTANCE);
        itemStorageProviders.register(CampfireBlock.class, CampfireProvider.INSTANCE);
    }

    @ProtocolHandler.PlayerJoin
    public static void onPlayerJoin(ServerPlayer player) {
        if (LeavesConfig.jadeProtocol) {
            ProtocolUtils.sendPayloadPacket(player, PACKET_SERVER_PING, buf -> buf.writeUtf(""));
        }
    }

    @ProtocolHandler.PayloadReceiver(payload=RequestEntityPayload.class, payloadId={"request_entity"})
    public static void requestEntityData(ServerPlayer player, RequestEntityPayload payload) {
        if (!LeavesConfig.jadeProtocol) {
            return;
        }
        MinecraftServer server = MinecraftServer.getServer();
        server.execute(() -> {
            List providers;
            EnderDragon dragon;
            EnderDragonPart[] parts;
            Level world = player.level();
            boolean showDetails = payload.showDetails;
            Entity entity = world.getEntity(payload.entityId);
            double maxDistance = Mth.square(player.entityInteractionRange() + 21.0);
            if (entity == null || player.distanceToSqr(entity) > maxDistance) {
                return;
            }
            if (payload.partIndex >= 0 && entity instanceof EnderDragon && payload.partIndex < (parts = (dragon = (EnderDragon)entity).getSubEntities()).length) {
                entity = parts[payload.partIndex];
            }
            if ((providers = entityDataProviders.get(entity)).isEmpty()) {
                return;
            }
            DataAccessor tag = new DataAccessor(world);
            EntityAccessor accessor = new EntityAccessor(player, world, entity, payload.hitVec, showDetails);
            for (IJadeDataProvider provider : providers) {
                try {
                    provider.saveData(tag, accessor);
                }
                catch (Exception e) {
                    LeavesLogger.LOGGER.warning("Error while saving data for entity " + String.valueOf(entity));
                }
            }
            tag.putInt("EntityId", entity.getId());
            ProtocolUtils.sendPayloadPacket(player, PACKET_RECEIVE_DATA, buf -> buf.writeNbt(tag));
        });
    }

    @ProtocolHandler.PayloadReceiver(payload=RequestBlockPayload.class, payloadId={"request_block"})
    public static void requestBlockData(ServerPlayer player, RequestBlockPayload payload) {
        if (!LeavesConfig.jadeProtocol) {
            return;
        }
        MinecraftServer server = MinecraftServer.getServer();
        server.execute(() -> {
            List<Object> providers;
            Level world = player.level();
            BlockState blockState = payload.blockState;
            Block block = blockState.getBlock();
            BlockHitResult result = payload.hitResult;
            BlockPos pos = result.getBlockPos();
            boolean showDetails = payload.showDetails;
            double maxDistance = Mth.square(player.blockInteractionRange() + 21.0);
            if (pos.distSqr(player.blockPosition()) > maxDistance || !world.isLoaded(pos)) {
                return;
            }
            BlockEntity blockEntity = null;
            if (blockState.hasBlockEntity()) {
                blockEntity = world.getBlockEntity(pos);
            }
            if ((providers = blockEntity != null ? blockDataProviders.getMerged(block, blockEntity) : JadeProtocol.blockDataProviders.first.get(block)).isEmpty()) {
                return;
            }
            DataAccessor tag = new DataAccessor(world);
            BlockAccessor accessor = new BlockAccessor(player, world, blockEntity, result, block, blockState, pos, showDetails);
            for (IJadeDataProvider iJadeDataProvider : providers) {
                try {
                    iJadeDataProvider.saveData(tag, accessor);
                }
                catch (Exception e) {
                    LeavesLogger.LOGGER.warning("Error while saving data for block " + String.valueOf(blockState));
                }
            }
            tag.putInt("x", pos.getX());
            tag.putInt("y", pos.getY());
            tag.putInt("z", pos.getZ());
            tag.putString("BlockId", BuiltInRegistries.BLOCK.getKey(block).toString());
            ProtocolUtils.sendPayloadPacket(player, PACKET_RECEIVE_DATA, buf -> buf.writeNbt(tag));
        });
    }

    @ProtocolHandler.ReloadServer
    public static void onServerReload() {
        if (LeavesConfig.jadeProtocol) {
            JadeProtocol.enableAllPlayer();
        }
    }

    public static void enableAllPlayer() {
        for (ServerPlayer player : MinecraftServer.getServer().getPlayerList().players) {
            JadeProtocol.onPlayerJoin(player);
        }
    }

    static {
        PACKET_SERVER_PING = JadeProtocol.id("server_ping");
        PACKET_RECEIVE_DATA = JadeProtocol.id("receive_data");
        entityDataProviders = new HierarchyLookup(Entity.class);
        blockDataProviders = new PairHierarchyLookup(new HierarchyLookup(Block.class), new HierarchyLookup(BlockEntity.class));
        itemStorageProviders = new WrappedHierarchyLookup();
    }

    public record RequestEntityPayload(boolean showDetails, int entityId, int partIndex, Vec3 hitVec) implements LeavesCustomPayload<RequestEntityPayload>
    {
        private static final ResourceLocation PACKET_REQUEST_ENTITY = JadeProtocol.id("request_entity");

        @LeavesCustomPayload.New
        public RequestEntityPayload(ResourceLocation id, FriendlyByteBuf buf) {
            this(buf.readBoolean(), buf.readVarInt(), buf.readVarInt(), new Vec3(buf.readVector3f()));
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.writeBoolean(this.showDetails);
            buf.writeVarInt(this.entityId);
            buf.writeVarInt(this.partIndex);
            buf.writeVector3f(this.hitVec.toVector3f());
        }

        @Override
        @NotNull
        public ResourceLocation id() {
            return PACKET_REQUEST_ENTITY;
        }
    }

    public record RequestBlockPayload(boolean showDetails, BlockHitResult hitResult, BlockState blockState, ItemStack fakeBlock) implements LeavesCustomPayload<RequestBlockPayload>
    {
        private static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> ITEM_STACK_CODEC = ItemStack.OPTIONAL_STREAM_CODEC;
        private static final StreamCodec<ByteBuf, BlockState> BLOCK_STATE_CODEC = ByteBufCodecs.idMapper(Block.BLOCK_STATE_REGISTRY);
        private static final ResourceLocation PACKET_REQUEST_BLOCK = JadeProtocol.id("request_block");

        @LeavesCustomPayload.New
        public RequestBlockPayload(ResourceLocation id, FriendlyByteBuf buf) {
            this(buf.readBoolean(), buf.readBlockHitResult(), (BlockState)BLOCK_STATE_CODEC.decode(buf), (ItemStack)ITEM_STACK_CODEC.decode(ProtocolUtils.decorate(buf)));
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.writeBoolean(this.showDetails);
            buf.writeBlockHitResult(this.hitResult);
            BLOCK_STATE_CODEC.encode(buf, this.blockState);
            ITEM_STACK_CODEC.encode(ProtocolUtils.decorate(buf), this.fakeBlock);
        }

        @Override
        @NotNull
        public ResourceLocation id() {
            return PACKET_REQUEST_BLOCK;
        }
    }
}

