/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol.jade.provider;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.LockCode;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import org.leavesmc.leaves.LeavesLogger;
import org.leavesmc.leaves.protocol.jade.JadeProtocol;
import org.leavesmc.leaves.protocol.jade.accessor.BlockAccessor;
import org.leavesmc.leaves.protocol.jade.accessor.RequestAccessor;
import org.leavesmc.leaves.protocol.jade.provider.IServerExtensionProvider;
import org.leavesmc.leaves.protocol.jade.util.ItemCollector;
import org.leavesmc.leaves.protocol.jade.util.ItemIterator;
import org.leavesmc.leaves.protocol.jade.util.ViewGroup;

public enum ItemStorageExtensionProvider implements IServerExtensionProvider<ItemStack>
{
    INSTANCE;

    public static final Cache<Object, ItemCollector<?>> targetCache;
    public static final Cache<Object, ItemCollector<?>> containerCache;
    private static final ResourceLocation UNIVERSAL_ITEM_STORAGE;

    @Override
    public List<ViewGroup<ItemStack>> getGroups(RequestAccessor<?> request) {
        ItemCollector itemCollector;
        Object blockAccessor;
        Block block;
        Object target = request.target();
        if (target == null && request instanceof BlockAccessor && (block = ((BlockAccessor)(blockAccessor = (BlockAccessor)request)).block()) instanceof WorldlyContainerHolder) {
            WorldlyContainerHolder holder = (WorldlyContainerHolder)((Object)block);
            WorldlyContainer container = holder.getContainer(((BlockAccessor)blockAccessor).blockState(), request.world(), ((BlockAccessor)blockAccessor).pos());
            return ItemStorageExtensionProvider.containerGroup(container, request);
        }
        blockAccessor = target;
        int holder = 0;
        block7: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RandomizableContainer.class, ContainerEntity.class}, blockAccessor, holder)) {
                case -1: {
                    return List.of();
                }
                case 0: {
                    RandomizableContainer te = (RandomizableContainer)blockAccessor;
                    if (te.getLootTable() == null) {
                        holder = 1;
                        continue block7;
                    }
                    return List.of();
                }
                case 1: {
                    ContainerEntity containerEntity = (ContainerEntity)blockAccessor;
                    if (containerEntity.getLootTable() == null) {
                        holder = 2;
                        continue block7;
                    }
                    return List.of();
                }
            }
            break;
        }
        ServerPlayer player = request.player();
        if (!((Player)player).isCreative() && !((Player)player).isSpectator() && target instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity te = (BaseContainerBlockEntity)target;
            if (te.lockKey != LockCode.NO_LOCK) {
                return List.of();
            }
        }
        if (target instanceof EnderChestBlockEntity) {
            PlayerEnderChestContainer inventory = player.getEnderChestInventory();
            return new ItemCollector<Container>(new ItemIterator.ContainerItemIterator(0)).update(inventory, request.world().getGameTime());
        }
        try {
            itemCollector = (ItemCollector)targetCache.get(target, () -> ItemStorageExtensionProvider.createItemCollector(target));
        }
        catch (ExecutionException e) {
            LeavesLogger.LOGGER.severe("Failed to get item collector for " + String.valueOf(target));
            return null;
        }
        if (itemCollector == ItemCollector.EMPTY) {
            return null;
        }
        return itemCollector.update(target, request.world().getGameTime());
    }

    @Override
    public ResourceLocation getUid() {
        return UNIVERSAL_ITEM_STORAGE;
    }

    public static List<ViewGroup<ItemStack>> containerGroup(Container container, RequestAccessor<?> accessor) {
        try {
            return ((ItemCollector)containerCache.get((Object)container, () -> new ItemCollector<Container>(new ItemIterator.ContainerItemIterator(0)))).update(container, accessor.world().getGameTime());
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public static ItemCollector<?> createItemCollector(Object target) {
        if (target instanceof AbstractHorse) {
            return new ItemCollector<Container>(new ItemIterator.ContainerItemIterator(o -> {
                if (o instanceof AbstractHorse) {
                    AbstractHorse horse = (AbstractHorse)o;
                    return horse.inventory;
                }
                return null;
            }, 2));
        }
        if (target instanceof Container) {
            if (target instanceof ChestBlockEntity) {
                return new ItemCollector<Container>(new ItemIterator.ContainerItemIterator(o -> {
                    if (o instanceof ChestBlockEntity) {
                        ChestBlockEntity blockEntity = (ChestBlockEntity)o;
                        Block patt0$temp = blockEntity.getBlockState().getBlock();
                        if (patt0$temp instanceof ChestBlock) {
                            ChestBlock chestBlock = (ChestBlock)patt0$temp;
                            Container compound = null;
                            if (blockEntity.getLevel() != null) {
                                compound = ChestBlock.getContainer(chestBlock, blockEntity.getBlockState(), blockEntity.getLevel(), blockEntity.getBlockPos(), false);
                            }
                            if (compound != null) {
                                return compound;
                            }
                        }
                        return blockEntity;
                    }
                    return null;
                }, 0));
            }
            return new ItemCollector<Container>(new ItemIterator.ContainerItemIterator(0));
        }
        return ItemCollector.EMPTY;
    }

    @Override
    public int getDefaultPriority() {
        return IServerExtensionProvider.super.getDefaultPriority() + 1000;
    }

    static {
        targetCache = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(60L, TimeUnit.SECONDS).build();
        containerCache = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(120L, TimeUnit.SECONDS).build();
        UNIVERSAL_ITEM_STORAGE = JadeProtocol.mc_id("item_storage.default");
    }
}

