/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol.jade.provider.block;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.LockCode;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.leavesmc.leaves.protocol.jade.JadeProtocol;
import org.leavesmc.leaves.protocol.jade.accessor.BlockAccessor;
import org.leavesmc.leaves.protocol.jade.accessor.DataAccessor;
import org.leavesmc.leaves.protocol.jade.provider.IJadeDataProvider;
import org.leavesmc.leaves.protocol.jade.provider.IServerExtensionProvider;
import org.leavesmc.leaves.protocol.jade.util.ViewGroup;

public enum BlockStorageProvider implements IJadeDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final ResourceLocation UNIVERSAL_ITEM_STORAGE;

    @Override
    public void saveData(DataAccessor data, BlockAccessor request) {
        BlockEntity target = request.target();
        ServerPlayer player = request.player();
        for (IServerExtensionProvider<ItemStack> provider : JadeProtocol.itemStorageProviders.get(request)) {
            RandomizableContainer containerEntity;
            List groups = provider.getGroups(request);
            if (groups == null) continue;
            if (ViewGroup.saveList(data, "JadeItemStorage", groups, item -> {
                int count = item.getCount();
                if (count > item.getMaxStackSize()) {
                    item.setCount(1);
                }
                CompoundTag itemTag = (CompoundTag)item.save(request.world().registryAccess());
                if (count > item.getMaxStackSize()) {
                    itemTag.putInt("NewCount", count);
                    item.setCount(count);
                }
                return itemTag;
            })) {
                data.putString("JadeItemStorageUid", provider.getUid().toString());
                break;
            }
            if (target instanceof RandomizableContainer && (containerEntity = (RandomizableContainer)((Object)target)).getLootTable() != null) {
                data.putBoolean("Loot", true);
                break;
            }
            if (((Player)player).isCreative() || ((Player)player).isSpectator() || !(target instanceof BaseContainerBlockEntity)) break;
            BaseContainerBlockEntity te = (BaseContainerBlockEntity)target;
            if (te.lockKey == LockCode.NO_LOCK) break;
            data.putBoolean("Locked", true);
            break;
        }
    }

    @Override
    public ResourceLocation getUid() {
        return UNIVERSAL_ITEM_STORAGE;
    }

    @Override
    public int getDefaultPriority() {
        return IJadeDataProvider.super.getDefaultPriority() + 1000;
    }

    static {
        UNIVERSAL_ITEM_STORAGE = JadeProtocol.mc_id("item_storage.default");
    }
}

