/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol.jade.provider.block;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import org.leavesmc.leaves.protocol.jade.JadeProtocol;
import org.leavesmc.leaves.protocol.jade.accessor.BlockAccessor;
import org.leavesmc.leaves.protocol.jade.accessor.DataAccessor;
import org.leavesmc.leaves.protocol.jade.provider.IJadeDataProvider;

public enum BrewingStandProvider implements IJadeDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final ResourceLocation MC_BREWING_STAND;

    @Override
    public void saveData(DataAccessor data, BlockAccessor request) {
        BlockEntity blockEntity = request.target();
        if (blockEntity instanceof BrewingStandBlockEntity) {
            BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)blockEntity;
            CompoundTag compound = new CompoundTag();
            compound.putInt("Time", brewingStand.brewTime);
            compound.putInt("Fuel", brewingStand.fuel);
            data.put("BrewingStand", compound);
        }
    }

    @Override
    public ResourceLocation getUid() {
        return MC_BREWING_STAND;
    }

    static {
        MC_BREWING_STAND = JadeProtocol.mc_id("brewing_stand");
    }
}

