/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol.jade.provider.block;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import org.leavesmc.leaves.protocol.jade.JadeProtocol;
import org.leavesmc.leaves.protocol.jade.accessor.RequestAccessor;
import org.leavesmc.leaves.protocol.jade.provider.IServerExtensionProvider;
import org.leavesmc.leaves.protocol.jade.util.ViewGroup;

public enum CampfireProvider implements IServerExtensionProvider<ItemStack>
{
    INSTANCE;

    private static final MapCodec<Integer> COOKING_TIME_CODEC;
    private static final ResourceLocation MC_CAMPFIRE;

    @Override
    public List<ViewGroup<ItemStack>> getGroups(RequestAccessor<?> request) {
        Object obj = request.target();
        if (obj instanceof CampfireBlockEntity) {
            CampfireBlockEntity campfire = (CampfireBlockEntity)obj;
            ArrayList list = Lists.newArrayList();
            for (int i = 0; i < campfire.cookingTime.length; ++i) {
                ItemStack stack = campfire.getItems().get(i);
                if (stack.isEmpty()) continue;
                stack = stack.copy();
                CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, CustomData.EMPTY).update(COOKING_TIME_CODEC, campfire.cookingTime[i] - campfire.cookingProgress[i]).getOrThrow();
                stack.set(DataComponents.CUSTOM_DATA, customData);
                list.add(stack);
            }
            return List.of(new ViewGroup(list));
        }
        return null;
    }

    @Override
    public ResourceLocation getUid() {
        return MC_CAMPFIRE;
    }

    static {
        COOKING_TIME_CODEC = Codec.INT.fieldOf("jade:cooking");
        MC_CAMPFIRE = JadeProtocol.mc_id("campfire");
    }
}

