/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol.jade.provider.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import org.leavesmc.leaves.protocol.jade.JadeProtocol;
import org.leavesmc.leaves.protocol.jade.accessor.BlockAccessor;
import org.leavesmc.leaves.protocol.jade.accessor.DataAccessor;
import org.leavesmc.leaves.protocol.jade.provider.IJadeDataProvider;
import org.leavesmc.leaves.protocol.jade.provider.block.BlockStorageProvider;

public enum ChiseledBookshelfProvider implements IJadeDataProvider<BlockAccessor>
{
    INSTANCE;

    public static final MapCodec<ItemStack> BOOK_CODEC;
    private static final ResourceLocation MC_CHISELED_BOOKSHELF;

    @Override
    public void saveData(DataAccessor data, BlockAccessor request) {
        BlockEntity blockEntity = request.target();
        if (blockEntity instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity bookshelf = (ChiseledBookShelfBlockEntity)blockEntity;
            int slot = ((ChiseledBookShelfBlock)request.block()).getHitSlot(request.hitResult(), request.blockState()).orElse(-1);
            if (slot == -1) {
                return;
            }
            ItemStack book = bookshelf.getItem(slot);
            if (!book.isEmpty()) {
                data.writeMapData(BOOK_CODEC, book);
            }
        }
    }

    @Override
    public ResourceLocation getUid() {
        return MC_CHISELED_BOOKSHELF;
    }

    @Override
    public int getDefaultPriority() {
        return BlockStorageProvider.INSTANCE.getDefaultPriority() + 1;
    }

    static {
        BOOK_CODEC = ItemStack.CODEC.fieldOf("book");
        MC_CHISELED_BOOKSHELF = JadeProtocol.mc_id("chiseled_bookshelf");
    }
}

