/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol.jade.provider.block;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import org.leavesmc.leaves.protocol.jade.JadeProtocol;
import org.leavesmc.leaves.protocol.jade.accessor.BlockAccessor;
import org.leavesmc.leaves.protocol.jade.accessor.DataAccessor;
import org.leavesmc.leaves.protocol.jade.provider.IJadeDataProvider;

public enum CommandBlockProvider implements IJadeDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final ResourceLocation MC_COMMAND_BLOCK;

    @Override
    public void saveData(DataAccessor data, BlockAccessor accessor) {
        ServerPlayer player = accessor.player();
        if (!player.canUseGameMasterBlocks()) {
            return;
        }
        BlockEntity blockEntity = accessor.target();
        if (blockEntity instanceof CommandBlockEntity) {
            CommandBlockEntity commandBlock = (CommandBlockEntity)blockEntity;
            BaseCommandBlock logic = commandBlock.getCommandBlock();
            Object command = logic.getCommand();
            if (((String)command).isEmpty()) {
                return;
            }
            if (((String)command).length() > 40) {
                command = ((String)command).substring(0, 37) + "...";
            }
            data.putString("Command", (String)command);
        }
    }

    @Override
    public ResourceLocation getUid() {
        return MC_COMMAND_BLOCK;
    }

    static {
        MC_COMMAND_BLOCK = JadeProtocol.mc_id("command_block");
    }
}

