/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol.jade.provider.block;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.leavesmc.leaves.protocol.jade.JadeProtocol;
import org.leavesmc.leaves.protocol.jade.accessor.BlockAccessor;
import org.leavesmc.leaves.protocol.jade.accessor.DataAccessor;
import org.leavesmc.leaves.protocol.jade.provider.IJadeDataProvider;

public enum FurnaceProvider implements IJadeDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final ResourceLocation MC_FURNACE;

    @Override
    public void saveData(DataAccessor data, BlockAccessor request) {
        BlockEntity blockEntity = request.target();
        if (!(blockEntity instanceof AbstractFurnaceBlockEntity)) {
            return;
        }
        AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)blockEntity;
        if (furnace.isEmpty()) {
            return;
        }
        ListTag items = new ListTag();
        for (int i = 0; i < 3; ++i) {
            items.add(furnace.getItem(i).saveOptional(request.world().registryAccess()));
        }
        data.put("furnace", items);
        CompoundTag furnaceTag = furnace.saveWithoutMetadata(request.world().registryAccess());
        data.putInt("progress", furnaceTag.getInt("CookTime"));
        data.putInt("total", furnaceTag.getInt("CookTimeTotal"));
    }

    @Override
    public ResourceLocation getUid() {
        return MC_FURNACE;
    }

    static {
        MC_FURNACE = JadeProtocol.mc_id("furnace");
    }
}

