/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol.jade.provider.block;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import org.leavesmc.leaves.protocol.jade.JadeProtocol;
import org.leavesmc.leaves.protocol.jade.accessor.BlockAccessor;
import org.leavesmc.leaves.protocol.jade.accessor.DataAccessor;
import org.leavesmc.leaves.protocol.jade.provider.IJadeDataProvider;

public enum MobSpawnerCooldownProvider implements IJadeDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final ResourceLocation MC_MOB_SPAWNER_COOLDOWN;

    @Override
    public void saveData(DataAccessor data, BlockAccessor request) {
        BlockEntity blockEntity = request.target();
        if (blockEntity instanceof TrialSpawnerBlockEntity) {
            TrialSpawnerBlockEntity spawner = (TrialSpawnerBlockEntity)blockEntity;
            TrialSpawnerData spawnerData = spawner.getTrialSpawner().getData();
            Level level = request.world();
            if (spawner.getTrialSpawner().canSpawnInLevel(level) && level.getGameTime() < spawnerData.cooldownEndsAt) {
                data.putInt("Cooldown", (int)(spawnerData.cooldownEndsAt - level.getGameTime()));
            }
        }
    }

    @Override
    public ResourceLocation getUid() {
        return MC_MOB_SPAWNER_COOLDOWN;
    }

    static {
        MC_MOB_SPAWNER_COOLDOWN = JadeProtocol.mc_id("mob_spawner.cooldown");
    }
}

