/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol.jade.provider.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import org.leavesmc.leaves.protocol.jade.JadeProtocol;
import org.leavesmc.leaves.protocol.jade.accessor.BlockAccessor;
import org.leavesmc.leaves.protocol.jade.accessor.DataAccessor;
import org.leavesmc.leaves.protocol.jade.provider.IJadeDataProvider;

public enum ObjectNameProvider implements IJadeDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final MapCodec<Component> GIVEN_NAME_CODEC;
    private static final ResourceLocation CORE_OBJECT_NAME;

    @Override
    public void saveData(DataAccessor data, BlockAccessor request) {
        BlockEntity blockEntity = request.target();
        if (blockEntity instanceof Nameable) {
            Nameable nameable = (Nameable)((Object)blockEntity);
            Component name = null;
            if (blockEntity instanceof ChestBlockEntity && request.block() instanceof ChestBlock) {
                MenuProvider menuProvider = request.blockState().getMenuProvider(request.world(), request.pos());
                if (menuProvider != null) {
                    name = menuProvider.getDisplayName();
                }
            } else if (nameable.hasCustomName()) {
                name = nameable.getDisplayName();
            }
            if (name != null) {
                data.writeMapData(GIVEN_NAME_CODEC, name);
            }
        }
    }

    @Override
    public ResourceLocation getUid() {
        return CORE_OBJECT_NAME;
    }

    @Override
    public int getDefaultPriority() {
        return -10100;
    }

    static {
        GIVEN_NAME_CODEC = ComponentSerialization.CODEC.fieldOf("given_name");
        CORE_OBJECT_NAME = JadeProtocol.id("object_name");
    }
}

