/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol.jade.provider.block;

import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.CalibratedSculkSensorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CalibratedSculkSensorBlockEntity;
import net.minecraft.world.level.block.entity.ComparatorBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import org.leavesmc.leaves.protocol.jade.JadeProtocol;
import org.leavesmc.leaves.protocol.jade.accessor.BlockAccessor;
import org.leavesmc.leaves.protocol.jade.accessor.DataAccessor;
import org.leavesmc.leaves.protocol.jade.provider.IJadeDataProvider;

public enum RedstoneProvider implements IJadeDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final ResourceLocation MC_REDSTONE;

    @Override
    public void saveData(DataAccessor data, BlockAccessor request) {
        BlockEntity blockEntity = request.target();
        if (blockEntity instanceof ComparatorBlockEntity) {
            ComparatorBlockEntity comparator = (ComparatorBlockEntity)blockEntity;
            data.putInt("Signal", comparator.getOutputSignal());
        } else if (blockEntity instanceof HopperBlockEntity) {
            BlockState state = request.blockState();
            if (state.hasProperty(BlockStateProperties.ENABLED) && !state.getValue(BlockStateProperties.ENABLED).booleanValue()) {
                data.putBoolean("HopperLocked", true);
            }
        } else if (blockEntity instanceof CalibratedSculkSensorBlockEntity) {
            Direction direction = request.blockState().getValue(CalibratedSculkSensorBlock.FACING).getOpposite();
            int signal = request.world().getSignal(request.pos().relative(direction), direction);
            data.putInt("Signal", signal);
        }
    }

    @Override
    public ResourceLocation getUid() {
        return MC_REDSTONE;
    }

    static {
        MC_REDSTONE = JadeProtocol.mc_id("redstone");
    }
}

