/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol.jade.provider.entity;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OwnableEntity;
import org.leavesmc.leaves.protocol.jade.JadeProtocol;
import org.leavesmc.leaves.protocol.jade.accessor.DataAccessor;
import org.leavesmc.leaves.protocol.jade.accessor.EntityAccessor;
import org.leavesmc.leaves.protocol.jade.provider.IJadeDataProvider;

public enum AnimalOwnerProvider implements IJadeDataProvider<EntityAccessor>
{
    INSTANCE;

    private static final ResourceLocation MC_ANIMAL_OWNER;

    @Override
    public void saveData(DataAccessor data, EntityAccessor request) {
        GameProfileCache cache;
        UUID ownerUUID = null;
        Entity entity = request.target();
        if (entity instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)((Object)entity);
            ownerUUID = ownable.getOwnerUUID();
        }
        if (ownerUUID != null && (cache = MinecraftServer.getServer().getProfileCache()) != null) {
            cache.get(ownerUUID).map(GameProfile::getName).ifPresent(name -> data.putString("OwnerName", (String)name));
        }
    }

    @Override
    public ResourceLocation getUid() {
        return MC_ANIMAL_OWNER;
    }

    static {
        MC_ANIMAL_OWNER = JadeProtocol.mc_id("animal_owner");
    }
}

