/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol.jade.provider.entity;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.leavesmc.leaves.protocol.jade.JadeProtocol;
import org.leavesmc.leaves.protocol.jade.accessor.DataAccessor;
import org.leavesmc.leaves.protocol.jade.accessor.EntityAccessor;
import org.leavesmc.leaves.protocol.jade.provider.IJadeDataProvider;
import org.leavesmc.leaves.protocol.jade.provider.IServerExtensionProvider;
import org.leavesmc.leaves.protocol.jade.util.ViewGroup;

public enum EntityStorageProvider implements IJadeDataProvider<EntityAccessor>
{
    INSTANCE;

    private static final ResourceLocation UNIVERSAL_ITEM_STORAGE;

    @Override
    public void saveData(DataAccessor data, EntityAccessor request) {
        for (IServerExtensionProvider<ItemStack> provider : JadeProtocol.itemStorageProviders.get(request)) {
            List groups = provider.getGroups(request);
            if (groups == null) continue;
            if (!ViewGroup.saveList(data, "JadeItemStorage", groups, item -> {
                int count = item.getCount();
                if (count > item.getMaxStackSize()) {
                    item.setCount(1);
                }
                CompoundTag itemTag = (CompoundTag)item.save(request.world().registryAccess());
                if (count > item.getMaxStackSize()) {
                    itemTag.putInt("NewCount", count);
                    item.setCount(count);
                }
                return itemTag;
            })) break;
            data.putString("JadeItemStorageUid", provider.getUid().toString());
            break;
        }
    }

    @Override
    public ResourceLocation getUid() {
        return UNIVERSAL_ITEM_STORAGE;
    }

    @Override
    public int getDefaultPriority() {
        return IJadeDataProvider.super.getDefaultPriority() + 1000;
    }

    static {
        UNIVERSAL_ITEM_STORAGE = JadeProtocol.mc_id("item_storage.default");
    }
}

