/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol.jade.provider.entity;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.allay.Allay;
import org.leavesmc.leaves.protocol.jade.JadeProtocol;
import org.leavesmc.leaves.protocol.jade.accessor.DataAccessor;
import org.leavesmc.leaves.protocol.jade.accessor.EntityAccessor;
import org.leavesmc.leaves.protocol.jade.provider.IJadeDataProvider;

public enum MobBreedingProvider implements IJadeDataProvider<EntityAccessor>
{
    INSTANCE;

    private static final ResourceLocation MC_MOB_BREEDING;

    @Override
    public void saveData(DataAccessor data, EntityAccessor request) {
        int time = 0;
        Entity entity = request.target();
        if (entity instanceof Allay) {
            Allay allay = (Allay)entity;
            if (allay.duplicationCooldown > 0L && allay.duplicationCooldown < Integer.MAX_VALUE) {
                time = (int)allay.duplicationCooldown;
            }
        } else if (entity instanceof Animal) {
            Animal animal = (Animal)entity;
            time = animal.getAge();
        }
        if (time > 0) {
            data.putInt("BreedingCD", time);
        }
    }

    @Override
    public ResourceLocation getUid() {
        return MC_MOB_BREEDING;
    }

    static {
        MC_MOB_BREEDING = JadeProtocol.mc_id("mob_breeding");
    }
}

