/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol.jade.provider.entity;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.frog.Tadpole;
import org.leavesmc.leaves.protocol.jade.JadeProtocol;
import org.leavesmc.leaves.protocol.jade.accessor.DataAccessor;
import org.leavesmc.leaves.protocol.jade.accessor.EntityAccessor;
import org.leavesmc.leaves.protocol.jade.provider.IJadeDataProvider;

public enum MobGrowthProvider implements IJadeDataProvider<EntityAccessor>
{
    INSTANCE;

    private static final ResourceLocation MC_MOB_GROWTH;

    @Override
    public void saveData(DataAccessor data, EntityAccessor request) {
        int time = -1;
        Entity entity = request.target();
        if (entity instanceof AgeableMob) {
            AgeableMob ageable = (AgeableMob)entity;
            time = -ageable.getAge();
        } else if (entity instanceof Tadpole) {
            Tadpole tadpole = (Tadpole)entity;
            time = tadpole.getTicksLeftUntilAdult();
        }
        if (time > 0) {
            data.putInt("GrowingTime", time);
        }
    }

    @Override
    public ResourceLocation getUid() {
        return MC_MOB_GROWTH;
    }

    static {
        MC_MOB_GROWTH = JadeProtocol.mc_id("mob_growth");
    }
}

