/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol.jade.provider.entity;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import org.leavesmc.leaves.protocol.jade.JadeProtocol;
import org.leavesmc.leaves.protocol.jade.accessor.DataAccessor;
import org.leavesmc.leaves.protocol.jade.accessor.EntityAccessor;
import org.leavesmc.leaves.protocol.jade.provider.IJadeDataProvider;

public enum NextEntityDropProvider implements IJadeDataProvider<EntityAccessor>
{
    INSTANCE;

    private static final ResourceLocation MC_NEXT_ENTITY_DROP;

    @Override
    public void saveData(DataAccessor data, EntityAccessor request) {
        Armadillo armadillo;
        int max = 48000;
        Entity entity = request.target();
        if (entity instanceof Chicken) {
            Chicken chicken = (Chicken)entity;
            if (!chicken.isBaby() && chicken.eggTime < max) {
                data.putInt("NextEggIn", chicken.eggTime);
            }
        } else if (entity instanceof Armadillo && !(armadillo = (Armadillo)entity).isBaby() && armadillo.scuteTime < max) {
            data.putInt("NextScuteIn", armadillo.scuteTime);
        }
    }

    @Override
    public ResourceLocation getUid() {
        return MC_NEXT_ENTITY_DROP;
    }

    static {
        MC_NEXT_ENTITY_DROP = JadeProtocol.mc_id("next_entity_drop");
    }
}

