/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol.jade.provider.entity;

import com.mojang.serialization.MapCodec;
import java.util.Collection;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import org.leavesmc.leaves.protocol.jade.JadeProtocol;
import org.leavesmc.leaves.protocol.jade.accessor.DataAccessor;
import org.leavesmc.leaves.protocol.jade.accessor.EntityAccessor;
import org.leavesmc.leaves.protocol.jade.provider.IJadeDataProvider;

public enum StatusEffectsProvider implements IJadeDataProvider<EntityAccessor>
{
    INSTANCE;

    private static final MapCodec<List<MobEffectInstance>> EFFECTS_CODEC;
    private static final ResourceLocation MC_POTION_EFFECTS;

    @Override
    public void saveData(DataAccessor data, EntityAccessor request) {
        LivingEntity living = (LivingEntity)request.target();
        Collection<MobEffectInstance> effects = living.getActiveEffects();
        if (effects.isEmpty()) {
            return;
        }
        List<MobEffectInstance> effectList = effects.stream().filter(MobEffectInstance::isVisible).toList();
        if (effectList.isEmpty()) {
            return;
        }
        data.writeMapData(EFFECTS_CODEC, effectList);
    }

    @Override
    public ResourceLocation getUid() {
        return MC_POTION_EFFECTS;
    }

    static {
        EFFECTS_CODEC = MobEffectInstance.CODEC.listOf().fieldOf("mob_effects");
        MC_POTION_EFFECTS = JadeProtocol.mc_id("potion_effects");
    }
}

