/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol.jade.util;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import org.leavesmc.leaves.LeavesLogger;
import org.leavesmc.leaves.protocol.jade.JadeProtocol;
import org.leavesmc.leaves.protocol.jade.provider.IJadeProvider;
import org.leavesmc.leaves.protocol.jade.util.IHierarchyLookup;
import org.leavesmc.leaves.protocol.jade.util.PriorityStore;

public class HierarchyLookup<T extends IJadeProvider>
implements IHierarchyLookup<T> {
    private final Class<?> baseClass;
    private final Cache<Class<?>, List<T>> resultCache = CacheBuilder.newBuilder().build();
    private final boolean singleton;
    private ListMultimap<Class<?>, T> objects = ArrayListMultimap.create();

    public HierarchyLookup(Class<?> baseClass) {
        this(baseClass, false);
    }

    public HierarchyLookup(Class<?> baseClass, boolean singleton) {
        this.baseClass = baseClass;
        this.singleton = singleton;
    }

    @Override
    public void register(Class<?> clazz, T provider) {
        Preconditions.checkArgument((boolean)this.isClassAcceptable(clazz), (String)"Class %s is not acceptable", clazz);
        Objects.requireNonNull(provider.getUid());
        JadeProtocol.priorities.put((IJadeProvider)provider);
        this.objects.put(clazz, provider);
    }

    @Override
    public boolean isClassAcceptable(Class<?> clazz) {
        return this.baseClass.isAssignableFrom(clazz);
    }

    @Override
    public List<T> get(Class<?> clazz) {
        try {
            return (List)this.resultCache.get(clazz, () -> {
                ArrayList list = Lists.newArrayList();
                this.getInternal(clazz, list);
                list = ImmutableList.sortedCopyOf(Comparator.comparingInt(JadeProtocol.priorities::byValue), (Iterable)list);
                if (this.singleton && !list.isEmpty()) {
                    return ImmutableList.of((Object)((IJadeProvider)list.getFirst()));
                }
                return list;
            });
        }
        catch (ExecutionException e) {
            LeavesLogger.LOGGER.severe(e.getMessage());
            return List.of();
        }
    }

    private void getInternal(Class<?> clazz, List<T> list) {
        if (clazz != this.baseClass && clazz != Object.class) {
            this.getInternal(clazz.getSuperclass(), list);
        }
        list.addAll(this.objects.get(clazz));
    }

    @Override
    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    @Override
    public Stream<Map.Entry<Class<?>, Collection<T>>> entries() {
        return this.objects.asMap().entrySet().stream();
    }

    @Override
    public void invalidate() {
        this.resultCache.invalidateAll();
    }

    @Override
    public void loadComplete(PriorityStore<ResourceLocation, IJadeProvider> priorityStore) {
        this.objects.asMap().forEach((clazz, list) -> {
            if (list.size() < 2) {
                return;
            }
            HashSet set = Sets.newHashSetWithExpectedSize((int)list.size());
            for (IJadeProvider provider : list) {
                if (set.contains(provider.getUid())) {
                    throw new IllegalStateException("Duplicate UID: %s for %s".formatted(provider.getUid(), list.stream().filter(p -> p.getUid().equals(provider.getUid())).map(p -> p.getClass().getName()).toList()));
                }
                set.add(provider.getUid());
            }
        });
        this.objects = ImmutableListMultimap.builder().orderValuesBy(Comparator.comparingInt(priorityStore::byValue)).putAll(this.objects).build();
    }
}

