/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol.jade.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.leavesmc.leaves.LeavesLogger;
import org.leavesmc.leaves.protocol.jade.JadeProtocol;
import org.leavesmc.leaves.protocol.jade.provider.IJadeProvider;
import org.leavesmc.leaves.protocol.jade.util.IHierarchyLookup;
import org.leavesmc.leaves.protocol.jade.util.PriorityStore;

public class PairHierarchyLookup<T extends IJadeProvider>
implements IHierarchyLookup<T> {
    public final IHierarchyLookup<T> first;
    public final IHierarchyLookup<T> second;
    private final Cache<Pair<Class<?>, Class<?>>, List<T>> mergedCache = CacheBuilder.newBuilder().build();

    public PairHierarchyLookup(IHierarchyLookup<T> first, IHierarchyLookup<T> second) {
        this.first = first;
        this.second = second;
    }

    public <ANY> List<ANY> getMerged(Object first, Object second) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        try {
            return (List)this.mergedCache.get((Object)Pair.of(first.getClass(), second.getClass()), () -> {
                List<T> firstList = this.first.get(first);
                List<T> secondList = this.second.get(second);
                if (firstList.isEmpty()) {
                    return secondList;
                }
                if (secondList.isEmpty()) {
                    return firstList;
                }
                return ImmutableList.sortedCopyOf(Comparator.comparingInt(JadeProtocol.priorities::byValue), (Iterable)Iterables.concat(firstList, secondList));
            });
        }
        catch (ExecutionException e) {
            LeavesLogger.LOGGER.severe(e.getMessage());
            return List.of();
        }
    }

    @Override
    public void register(Class<?> clazz, T provider) {
        if (this.first.isClassAcceptable(clazz)) {
            this.first.register(clazz, provider);
        } else if (this.second.isClassAcceptable(clazz)) {
            this.second.register(clazz, provider);
        } else {
            throw new IllegalArgumentException("Class " + String.valueOf(clazz) + " is not acceptable");
        }
    }

    @Override
    public boolean isClassAcceptable(Class<?> clazz) {
        return this.first.isClassAcceptable(clazz) || this.second.isClassAcceptable(clazz);
    }

    @Override
    public List<T> get(Class<?> clazz) {
        List<T> result = this.first.get(clazz);
        if (result.isEmpty()) {
            result = this.second.get(clazz);
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.first.isEmpty() && this.second.isEmpty();
    }

    @Override
    public Stream<Map.Entry<Class<?>, Collection<T>>> entries() {
        return Stream.concat(this.first.entries(), this.second.entries());
    }

    @Override
    public void invalidate() {
        this.first.invalidate();
        this.second.invalidate();
        this.mergedCache.invalidateAll();
    }

    @Override
    public void loadComplete(PriorityStore<ResourceLocation, IJadeProvider> priorityStore) {
        this.first.loadComplete(priorityStore);
        this.second.loadComplete(priorityStore);
    }
}

