/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.protocol.jade.util;

import java.util.List;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class ViewGroup<T> {
    public final List<T> views;
    @Nullable
    public String id;
    @Nullable
    protected CompoundTag extraData;

    public ViewGroup(List<T> views) {
        this.views = views;
    }

    public void save(CompoundTag tag, Function<T, CompoundTag> writer) {
        ListTag list = new ListTag();
        for (T view : this.views) {
            list.add((Tag)writer.apply(view));
        }
        tag.put("Views", list);
        if (this.id != null) {
            tag.putString("Id", this.id);
        }
        if (this.extraData != null) {
            tag.put("Data", this.extraData);
        }
    }

    public static <T> boolean saveList(CompoundTag tag, String key, List<ViewGroup<T>> groups, Function<T, CompoundTag> writer) {
        if (groups == null || groups.isEmpty()) {
            return false;
        }
        ListTag groupList = new ListTag();
        for (ViewGroup<T> group : groups) {
            if (group.views.isEmpty()) continue;
            CompoundTag groupTag = new CompoundTag();
            group.save(groupTag, writer);
            groupList.add(groupTag);
        }
        if (!groupList.isEmpty()) {
            tag.put(key, groupList);
            return true;
        }
        return false;
    }

    public CompoundTag getExtraData() {
        if (this.extraData == null) {
            this.extraData = new CompoundTag();
        }
        return this.extraData;
    }
}

