/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.region;

import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionFileVersion;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.leavesmc.leaves.region.AbstractRegionFile;
import org.leavesmc.leaves.region.LinearRegionFile;

public class AbstractRegionFileFactory {
    public static AbstractRegionFile getAbstractRegionFile(int linearCompression, RegionStorageInfo storageKey, Path file, Path directory, boolean dsync) throws IOException {
        return AbstractRegionFileFactory.getAbstractRegionFile(linearCompression, storageKey, file, directory, RegionFileVersion.VERSION_DEFLATE, dsync);
    }

    public static AbstractRegionFile getAbstractRegionFile(int linearCompression, RegionStorageInfo storageKey, Path file, Path directory, boolean dsync, boolean canRecalcHeader) throws IOException {
        return AbstractRegionFileFactory.getAbstractRegionFile(linearCompression, storageKey, file, directory, RegionFileVersion.VERSION_DEFLATE, dsync, canRecalcHeader);
    }

    public static AbstractRegionFile getAbstractRegionFile(int linearCompression, RegionStorageInfo storageKey, Path file, Path directory, RegionFileVersion outputChunkStreamVersion, boolean dsync) throws IOException {
        return AbstractRegionFileFactory.getAbstractRegionFile(linearCompression, storageKey, file, directory, outputChunkStreamVersion, dsync, false);
    }

    public static AbstractRegionFile getAbstractRegionFile(int linearCompression, RegionStorageInfo storageKey, Path file, Path directory, RegionFileVersion outputChunkStreamVersion, boolean dsync, boolean canRecalcHeader) throws IOException {
        if (file.toString().endsWith(".linear")) {
            return new LinearRegionFile(file, linearCompression);
        }
        return new RegionFile(storageKey, file, directory, outputChunkStreamVersion, dsync, canRecalcHeader);
    }
}

