/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.region;

import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import com.mojang.logging.LogUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.leavesmc.leaves.region.AbstractRegionFile;
import org.leavesmc.leaves.region.LinearRegionFileFlusher;
import org.slf4j.Logger;

public class LinearRegionFile
implements AbstractRegionFile,
AutoCloseable {
    private static final long SUPERBLOCK = -4323716122432332390L;
    private static final byte VERSION = 2;
    private static final int HEADER_SIZE = 32;
    private static final int FOOTER_SIZE = 8;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final List<Byte> SUPPORTED_VERSIONS = Arrays.asList((byte)1, (byte)2);
    private static final LinearRegionFileFlusher linearRegionFileFlusher = new LinearRegionFileFlusher();
    private final byte[][] buffer = new byte[1024][];
    private final int[] bufferUncompressedSize = new int[1024];
    private final int[] chunkTimestamps = new int[1024];
    private final ChunkStatus[] statuses = new ChunkStatus[1024];
    private final LZ4Compressor compressor;
    private final LZ4FastDecompressor decompressor;
    public final ReentrantLock fileLock = new ReentrantLock(true);
    private final int compressionLevel;
    private final AtomicBoolean markedToSave = new AtomicBoolean(false);
    public boolean closed = false;
    public Path path;

    public LinearRegionFile(Path file, int compression) throws IOException {
        this.path = file;
        this.compressionLevel = compression;
        this.compressor = LZ4Factory.fastestInstance().fastCompressor();
        this.decompressor = LZ4Factory.fastestInstance().fastDecompressor();
        File regionFile = new File(this.path.toString());
        Arrays.fill(this.bufferUncompressedSize, 0);
        if (!regionFile.canRead()) {
            return;
        }
        try (FileInputStream fileStream = new FileInputStream(regionFile);
             DataInputStream rawDataStream = new DataInputStream(fileStream);){
            long superBlock = rawDataStream.readLong();
            if (superBlock != -4323716122432332390L) {
                throw new RuntimeException("Invalid superblock: " + superBlock + " in " + String.valueOf(file));
            }
            byte version = rawDataStream.readByte();
            if (!SUPPORTED_VERSIONS.contains(version)) {
                throw new RuntimeException("Invalid version: " + version + " in " + String.valueOf(file));
            }
            rawDataStream.skipBytes(11);
            int dataCount = rawDataStream.readInt();
            long fileLength = file.toFile().length();
            if (fileLength != (long)(32 + dataCount + 8)) {
                throw new IOException("Invalid file length: " + String.valueOf(this.path) + " " + fileLength + " " + (32 + dataCount + 8));
            }
            rawDataStream.skipBytes(8);
            byte[] rawCompressed = new byte[dataCount];
            rawDataStream.readFully(rawCompressed, 0, dataCount);
            superBlock = rawDataStream.readLong();
            if (superBlock != -4323716122432332390L) {
                throw new IOException("Footer superblock invalid " + String.valueOf(this.path));
            }
            try (DataInputStream dataStream = new DataInputStream((InputStream)new ZstdInputStream((InputStream)new ByteArrayInputStream(rawCompressed)));){
                int i;
                int[] starts = new int[1024];
                for (i = 0; i < 1024; ++i) {
                    starts[i] = dataStream.readInt();
                    dataStream.skipBytes(4);
                }
                for (i = 0; i < 1024; ++i) {
                    if (starts[i] <= 0) continue;
                    int size = starts[i];
                    byte[] b = new byte[size];
                    dataStream.readFully(b, 0, size);
                    int maxCompressedLength = this.compressor.maxCompressedLength(size);
                    byte[] compressed = new byte[maxCompressedLength];
                    int compressedLength = this.compressor.compress(b, 0, size, compressed, 0, maxCompressedLength);
                    b = new byte[compressedLength];
                    System.arraycopy(compressed, 0, b, 0, compressedLength);
                    this.buffer[i] = b;
                    this.bufferUncompressedSize[i] = size;
                }
            }
        }
    }

    @Override
    public Path getRegionFile() {
        return this.path;
    }

    @Override
    public ReentrantLock getFileLock() {
        return this.fileLock;
    }

    @Override
    public void flush() throws IOException {
        if (this.isMarkedToSave()) {
            this.flushWrapper();
        }
    }

    private void markToSave() {
        linearRegionFileFlusher.scheduleSave(this);
        this.markedToSave.set(true);
    }

    public boolean isMarkedToSave() {
        return this.markedToSave.getAndSet(false);
    }

    public void flushWrapper() {
        try {
            this.save();
        }
        catch (IOException e) {
            LOGGER.error("Failed to flush region file " + String.valueOf(this.path.toAbsolutePath()), (Throwable)e);
        }
    }

    @Override
    public boolean doesChunkExist(ChunkPos pos) throws Exception {
        throw new Exception("doesChunkExist is a stub");
    }

    private synchronized void save() throws IOException {
        long timestamp = LinearRegionFile.getTimestamp();
        int chunkCount = 0;
        File tempFile = new File(this.path.toString() + ".tmp");
        try (FileOutputStream fileStream = new FileOutputStream(tempFile);
             ByteArrayOutputStream zstdByteArray = new ByteArrayOutputStream();
             ZstdOutputStream zstdStream = new ZstdOutputStream((OutputStream)zstdByteArray, this.compressionLevel);
             DataOutputStream zstdDataStream = new DataOutputStream((OutputStream)zstdStream);
             DataOutputStream dataStream = new DataOutputStream(fileStream);){
            int i;
            dataStream.writeLong(-4323716122432332390L);
            dataStream.writeByte(2);
            dataStream.writeLong(timestamp);
            dataStream.writeByte(this.compressionLevel);
            ArrayList<byte[]> byteBuffers = new ArrayList<byte[]>();
            for (i = 0; i < 1024; ++i) {
                if (this.bufferUncompressedSize[i] != 0) {
                    chunkCount = (short)(chunkCount + 1);
                    byte[] content = new byte[this.bufferUncompressedSize[i]];
                    this.decompressor.decompress(this.buffer[i], 0, content, 0, this.bufferUncompressedSize[i]);
                    byteBuffers.add(content);
                    continue;
                }
                byteBuffers.add(null);
            }
            for (i = 0; i < 1024; ++i) {
                zstdDataStream.writeInt(this.bufferUncompressedSize[i]);
                zstdDataStream.writeInt(this.chunkTimestamps[i]);
            }
            for (i = 0; i < 1024; ++i) {
                if (byteBuffers.get(i) == null) continue;
                zstdDataStream.write((byte[])byteBuffers.get(i), 0, ((byte[])byteBuffers.get(i)).length);
            }
            zstdDataStream.close();
            dataStream.writeShort(chunkCount);
            byte[] compressed = zstdByteArray.toByteArray();
            dataStream.writeInt(compressed.length);
            dataStream.writeLong(0L);
            dataStream.write(compressed, 0, compressed.length);
            dataStream.writeLong(-4323716122432332390L);
            dataStream.flush();
            fileStream.getFD().sync();
            fileStream.getChannel().force(true);
        }
        Files.move(tempFile.toPath(), this.path, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public void setStatus(int x, int z, ChunkStatus status) {
        this.statuses[LinearRegionFile.getChunkIndex((int)x, (int)z)] = status;
    }

    public synchronized void write(ChunkPos pos, ByteBuffer buffer) {
        try {
            byte[] b = this.toByteArray(new ByteArrayInputStream(buffer.array()));
            int uncompressedSize = b.length;
            int maxCompressedLength = this.compressor.maxCompressedLength(b.length);
            byte[] compressed = new byte[maxCompressedLength];
            int compressedLength = this.compressor.compress(b, 0, b.length, compressed, 0, maxCompressedLength);
            b = new byte[compressedLength];
            System.arraycopy(compressed, 0, b, 0, compressedLength);
            int index = LinearRegionFile.getChunkIndex(pos.x, pos.z);
            this.buffer[index] = b;
            this.chunkTimestamps[index] = LinearRegionFile.getTimestamp();
            this.bufferUncompressedSize[LinearRegionFile.getChunkIndex((int)pos.x, (int)pos.z)] = uncompressedSize;
        }
        catch (IOException e) {
            LOGGER.error("Chunk write IOException " + String.valueOf(e) + " " + String.valueOf(this.path));
        }
        this.markToSave();
    }

    @Override
    public DataOutputStream getChunkDataOutputStream(ChunkPos pos) {
        return new DataOutputStream(new BufferedOutputStream(new ChunkBuffer(pos)));
    }

    private byte[] toByteArray(InputStream in) throws IOException {
        int length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] tempBuffer = new byte[4096];
        while ((length = in.read(tempBuffer)) >= 0) {
            out.write(tempBuffer, 0, length);
        }
        return out.toByteArray();
    }

    @Override
    @Nullable
    public synchronized DataInputStream getChunkDataInputStream(ChunkPos pos) {
        if (this.bufferUncompressedSize[LinearRegionFile.getChunkIndex(pos.x, pos.z)] != 0) {
            byte[] content = new byte[this.bufferUncompressedSize[LinearRegionFile.getChunkIndex(pos.x, pos.z)]];
            this.decompressor.decompress(this.buffer[LinearRegionFile.getChunkIndex(pos.x, pos.z)], 0, content, 0, this.bufferUncompressedSize[LinearRegionFile.getChunkIndex(pos.x, pos.z)]);
            return new DataInputStream(new ByteArrayInputStream(content));
        }
        return null;
    }

    @Override
    public ChunkStatus getStatusIfCached(int x, int z) {
        return this.statuses[LinearRegionFile.getChunkIndex(x, z)];
    }

    @Override
    public void clear(ChunkPos pos) {
        int i = LinearRegionFile.getChunkIndex(pos.x, pos.z);
        this.buffer[i] = null;
        this.bufferUncompressedSize[i] = 0;
        this.chunkTimestamps[i] = LinearRegionFile.getTimestamp();
        this.markToSave();
    }

    @Override
    public boolean hasChunk(ChunkPos pos) {
        return this.bufferUncompressedSize[LinearRegionFile.getChunkIndex(pos.x, pos.z)] > 0;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.flush();
    }

    private static int getChunkIndex(int x, int z) {
        return (x & 0x1F) + ((z & 0x1F) << 5);
    }

    private static int getTimestamp() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    @Override
    public boolean recalculateHeader() {
        return false;
    }

    @Override
    public void setOversized(int x, int z, boolean something) {
    }

    @Override
    public CompoundTag getOversizedData(int x, int z) throws IOException {
        throw new IOException("getOversizedData is a stub " + String.valueOf(this.path));
    }

    @Override
    public boolean isOversized(int x, int z) {
        return false;
    }

    private class ChunkBuffer
    extends ByteArrayOutputStream {
        private final ChunkPos pos;

        public ChunkBuffer(ChunkPos chunkcoordintpair) {
            this.pos = chunkcoordintpair;
        }

        @Override
        public void close() {
            ByteBuffer bytebuffer = ByteBuffer.wrap(this.buf, 0, this.count);
            LinearRegionFile.this.write(this.pos, bytebuffer);
        }
    }
}

