/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.region;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.leavesmc.leaves.LeavesConfig;
import org.leavesmc.leaves.LeavesLogger;
import org.leavesmc.leaves.region.LinearRegionFile;

public class LinearRegionFileFlusher {
    private final Queue<LinearRegionFile> savingQueue = new LinkedBlockingQueue<LinearRegionFile>();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("linear-flush-scheduler").build());
    private final ExecutorService executor = Executors.newFixedThreadPool(LeavesConfig.getLinearFlushThreads(), new ThreadFactoryBuilder().setNameFormat("linear-flusher-%d").build());

    public LinearRegionFileFlusher() {
        LeavesLogger.LOGGER.info("Using " + LeavesConfig.getLinearFlushThreads() + " threads for linear region flushing.");
        this.scheduler.scheduleAtFixedRate(this::pollAndFlush, 0L, LeavesConfig.linearFlushFrequency, TimeUnit.SECONDS);
    }

    public void scheduleSave(LinearRegionFile regionFile) {
        if (this.savingQueue.contains(regionFile)) {
            return;
        }
        this.savingQueue.add(regionFile);
    }

    private void pollAndFlush() {
        while (!this.savingQueue.isEmpty()) {
            LinearRegionFile regionFile = this.savingQueue.poll();
            if (regionFile.closed || !regionFile.isMarkedToSave()) continue;
            this.executor.execute(regionFile::flushWrapper);
        }
    }

    public void shutdown() {
        this.executor.shutdown();
        this.scheduler.shutdown();
    }
}

