/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.replay;

import io.netty.channel.local.LocalChannel;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraft.SharedConstants;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPushPacket;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.common.custom.BrandPayload;
import net.minecraft.network.protocol.configuration.ClientboundFinishConfigurationPacket;
import net.minecraft.network.protocol.configuration.ClientboundRegistryDataPacket;
import net.minecraft.network.protocol.configuration.ClientboundSelectKnownPacks;
import net.minecraft.network.protocol.configuration.ClientboundUpdateEnabledFeaturesPacket;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.login.ClientboundGameProfilePacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.leavesmc.leaves.LeavesLogger;
import org.leavesmc.leaves.replay.RecordMetaData;
import org.leavesmc.leaves.replay.RecorderOption;
import org.leavesmc.leaves.replay.ReplayFile;
import org.leavesmc.leaves.replay.ServerPhotographer;

public class Recorder
extends Connection {
    private static final LeavesLogger LOGGER = LeavesLogger.LOGGER;
    private final ReplayFile replayFile;
    private final ServerPhotographer photographer;
    private final RecorderOption recorderOption;
    private final RecordMetaData metaData;
    private final ExecutorService saveService = Executors.newSingleThreadExecutor();
    private boolean stopped = false;
    private boolean paused = false;
    private boolean resumeOnNextPacket = true;
    private long startTime;
    private long lastPacket;
    private long timeShift = 0L;
    private boolean isSaved;
    private boolean isSaving;
    private ConnectionProtocol state = ConnectionProtocol.LOGIN;

    public Recorder(ServerPhotographer photographer, RecorderOption recorderOption, File replayFile) throws IOException {
        super(PacketFlow.CLIENTBOUND);
        this.photographer = photographer;
        this.recorderOption = recorderOption;
        this.metaData = new RecordMetaData();
        this.replayFile = new ReplayFile(replayFile);
        this.channel = new LocalChannel();
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        this.metaData.singleplayer = false;
        this.metaData.serverName = this.recorderOption.serverName;
        this.metaData.generator = "leaves";
        this.metaData.date = this.startTime;
        this.metaData.mcversion = SharedConstants.getCurrentVersion().getName();
        this.savePacket(new ClientboundGameProfilePacket(this.photographer.getGameProfile(), true), ConnectionProtocol.LOGIN);
        this.startConfiguration();
        if (this.recorderOption.forceWeather != null) {
            this.setWeather(this.recorderOption.forceWeather);
        }
    }

    public void startConfiguration() {
        this.state = ConnectionProtocol.CONFIGURATION;
        MinecraftServer server = MinecraftServer.getServer();
        this.savePacket(new ClientboundCustomPayloadPacket(new BrandPayload(server.getServerModName())), ConnectionProtocol.CONFIGURATION);
        this.savePacket(new ClientboundUpdateEnabledFeaturesPacket(FeatureFlags.REGISTRY.toNames(server.getWorldData().enabledFeatures())), ConnectionProtocol.CONFIGURATION);
        List<KnownPack> knownPackslist = server.getResourceManager().listPacks().flatMap(iresourcepack -> iresourcepack.location().knownPackInfo().stream()).toList();
        LayeredRegistryAccess<RegistryLayer> layeredregistryaccess = server.registries();
        this.savePacket(new ClientboundSelectKnownPacks(knownPackslist), ConnectionProtocol.CONFIGURATION);
        RegistryOps<Tag> dynamicOps = layeredregistryaccess.compositeAccess().createSerializationContext(NbtOps.INSTANCE);
        RegistrySynchronization.packRegistries(dynamicOps, layeredregistryaccess.getAccessFrom(RegistryLayer.WORLDGEN), Set.copyOf(knownPackslist), (key, entries) -> this.savePacket(new ClientboundRegistryDataPacket((ResourceKey<? extends Registry<?>>)key, (List<RegistrySynchronization.PackedRegistryEntry>)entries), ConnectionProtocol.CONFIGURATION));
        this.savePacket(new ClientboundUpdateTagsPacket(TagNetworkSerialization.serializeTagsToNetwork(layeredregistryaccess)), ConnectionProtocol.CONFIGURATION);
        server.getServerResourcePack().ifPresent(info -> this.savePacket(new ClientboundResourcePackPushPacket(info.id(), info.url(), info.hash(), info.isRequired(), Optional.ofNullable(info.prompt())), ConnectionProtocol.CONFIGURATION));
        this.savePacket(ClientboundFinishConfigurationPacket.INSTANCE, ConnectionProtocol.CONFIGURATION);
        this.state = ConnectionProtocol.PLAY;
    }

    @Override
    public void flushChannel() {
    }

    public void stop() {
        this.stopped = true;
    }

    public void pauseRecording() {
        this.resumeOnNextPacket = false;
        this.paused = true;
    }

    public void resumeRecording() {
        this.resumeOnNextPacket = true;
    }

    public void setWeather(RecorderOption.RecordWeather weather) {
        weather.getPackets().forEach(this::savePacket);
    }

    public long getRecordedTime() {
        long base = System.currentTimeMillis() - this.startTime;
        return base - this.timeShift;
    }

    private synchronized long getCurrentTimeAndUpdate() {
        long now = this.getRecordedTime();
        if (this.paused) {
            if (this.resumeOnNextPacket) {
                this.paused = false;
            }
            this.timeShift += now - this.lastPacket;
            return this.lastPacket;
        }
        this.lastPacket = now;
        return this.lastPacket;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void send(@NotNull Packet<?> packet, @Nullable PacketSendListener callbacks, boolean flush) {
        if (!this.stopped) {
            ClientboundGameEventPacket.Type type;
            Packet<ClientGamePacketListener> packet1;
            if (packet instanceof BundlePacket) {
                BundlePacket packet12 = (BundlePacket)((Object)packet);
                packet12.subPackets().forEach(subPacket -> this.send((Packet<?>)subPacket, null));
                return;
            }
            if (packet instanceof ClientboundAddEntityPacket && ((ClientboundAddEntityPacket)(packet1 = (ClientboundAddEntityPacket)((Object)packet))).getType() == EntityType.PLAYER) {
                this.metaData.players.add(((ClientboundAddEntityPacket)packet1).getUUID());
                this.saveMetadata();
            }
            if (packet instanceof ClientboundDisconnectPacket) {
                return;
            }
            if (this.recorderOption.forceDayTime != -1 && packet instanceof ClientboundSetTimePacket) {
                packet1 = packet;
                packet = new ClientboundSetTimePacket(((ClientboundSetTimePacket)packet1).getDayTime(), this.recorderOption.forceDayTime, false);
            }
            if (this.recorderOption.forceWeather != null && packet instanceof ClientboundGameEventPacket && ((type = ((ClientboundGameEventPacket)(packet1 = (ClientboundGameEventPacket)((Object)packet))).getEvent()) == ClientboundGameEventPacket.START_RAINING || type == ClientboundGameEventPacket.STOP_RAINING || type == ClientboundGameEventPacket.RAIN_LEVEL_CHANGE || type == ClientboundGameEventPacket.THUNDER_LEVEL_CHANGE)) {
                return;
            }
            if (this.recorderOption.ignoreChat && (packet instanceof ClientboundSystemChatPacket || packet instanceof ClientboundPlayerChatPacket)) {
                return;
            }
            this.savePacket(packet);
        }
    }

    private void saveMetadata() {
        this.saveService.submit(() -> {
            try {
                this.replayFile.saveMetaData(this.metaData);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private void savePacket(Packet<?> packet) {
        this.savePacket(packet, this.state);
    }

    private void savePacket(Packet<?> packet, ConnectionProtocol protocol) {
        try {
            long timestamp = this.getCurrentTimeAndUpdate();
            this.saveService.submit(() -> {
                try {
                    this.replayFile.savePacket(timestamp, packet, protocol);
                }
                catch (Exception e) {
                    LOGGER.severe("Error saving packet");
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            LOGGER.severe("Error saving packet");
            e.printStackTrace();
        }
    }

    public boolean isSaved() {
        return this.isSaved;
    }

    public CompletableFuture<Void> saveRecording(File dest, boolean save) {
        this.isSaved = true;
        if (!this.isSaving) {
            this.isSaving = true;
            this.metaData.duration = (int)this.lastPacket;
            return CompletableFuture.runAsync(() -> {
                this.saveMetadata();
                this.saveService.shutdown();
                boolean interrupted = false;
                try {
                    this.saveService.awaitTermination(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                try {
                    if (save) {
                        this.replayFile.closeAndSave(dest);
                    } else {
                        this.replayFile.closeNotSave();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new CompletionException(e);
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }, runnable -> {
                Thread thread = new Thread(runnable, "Recording file save thread");
                thread.start();
            });
        }
        LOGGER.warning("saveRecording() called twice");
        return CompletableFuture.supplyAsync(() -> {
            throw new IllegalStateException("saveRecording() called twice");
        });
    }
}

