/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.replay;

import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.leavesmc.leaves.replay.BukkitRecorderOption;

public class RecorderOption {
    public int recordDistance = -1;
    public String serverName = "Leaves";
    public RecordWeather forceWeather = null;
    public int forceDayTime = -1;
    public boolean ignoreChat = false;
    public boolean ignoreItem = false;

    @NotNull
    @Contract(value=" -> new")
    public static RecorderOption createDefaultOption() {
        return new RecorderOption();
    }

    @NotNull
    public static RecorderOption createFromBukkit(@NotNull BukkitRecorderOption bukkitRecorderOption) {
        RecorderOption recorderOption = new RecorderOption();
        recorderOption.serverName = bukkitRecorderOption.serverName;
        recorderOption.ignoreChat = bukkitRecorderOption.ignoreChat;
        recorderOption.forceDayTime = bukkitRecorderOption.forceDayTime;
        recorderOption.forceWeather = switch (bukkitRecorderOption.forceWeather) {
            default -> throw new MatchException(null, null);
            case BukkitRecorderOption.BukkitRecordWeather.RAIN -> RecordWeather.RAIN;
            case BukkitRecorderOption.BukkitRecordWeather.CLEAR -> RecordWeather.CLEAR;
            case BukkitRecorderOption.BukkitRecordWeather.THUNDER -> RecordWeather.THUNDER;
            case BukkitRecorderOption.BukkitRecordWeather.NULL -> null;
        };
        return recorderOption;
    }

    public static enum RecordWeather {
        CLEAR(new ClientboundGameEventPacket(ClientboundGameEventPacket.STOP_RAINING, 0.0f), new ClientboundGameEventPacket(ClientboundGameEventPacket.RAIN_LEVEL_CHANGE, 0.0f), new ClientboundGameEventPacket(ClientboundGameEventPacket.THUNDER_LEVEL_CHANGE, 0.0f)),
        RAIN(new ClientboundGameEventPacket(ClientboundGameEventPacket.START_RAINING, 0.0f), new ClientboundGameEventPacket(ClientboundGameEventPacket.RAIN_LEVEL_CHANGE, 1.0f), new ClientboundGameEventPacket(ClientboundGameEventPacket.THUNDER_LEVEL_CHANGE, 0.0f)),
        THUNDER(new ClientboundGameEventPacket(ClientboundGameEventPacket.START_RAINING, 0.0f), new ClientboundGameEventPacket(ClientboundGameEventPacket.RAIN_LEVEL_CHANGE, 1.0f), new ClientboundGameEventPacket(ClientboundGameEventPacket.THUNDER_LEVEL_CHANGE, 1.0f));

        private final List<Packet<?>> packets;

        private RecordWeather(Packet<?> ... packets) {
            this.packets = List.of(packets);
        }

        public List<Packet<?>> getPackets() {
            return this.packets;
        }
    }
}

