/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.replay;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.craftbukkit.CraftWorld;
import org.jetbrains.annotations.NotNull;
import org.leavesmc.leaves.LeavesLogger;
import org.leavesmc.leaves.bot.BotStatsCounter;
import org.leavesmc.leaves.bot.ServerBot;
import org.leavesmc.leaves.entity.CraftPhotographer;
import org.leavesmc.leaves.entity.Photographer;
import org.leavesmc.leaves.replay.Recorder;
import org.leavesmc.leaves.replay.RecorderOption;
import org.leavesmc.leaves.replay.ServerPhotographerGameMode;

public class ServerPhotographer
extends ServerPlayer {
    private static final List<ServerPhotographer> photographers = new CopyOnWriteArrayList<ServerPhotographer>();
    public PhotographerCreateState createState;
    private ServerPlayer followPlayer;
    private Recorder recorder;
    private File saveFile;
    private Vec3 lastPos;
    private final ServerStatsCounter stats;

    private ServerPhotographer(MinecraftServer server, ServerLevel world, GameProfile profile) {
        super(server, world, profile, ClientInformation.createDefault());
        this.gameMode = new ServerPhotographerGameMode(this);
        this.followPlayer = null;
        this.stats = new BotStatsCounter(server);
        this.lastPos = this.position();
    }

    public static ServerPhotographer createPhotographer(@NotNull PhotographerCreateState state) throws IOException {
        if (!ServerBot.isCreateLegal(state.id)) {
            return null;
        }
        MinecraftServer server = MinecraftServer.getServer();
        ServerLevel world = ((CraftWorld)state.loc.getWorld()).getHandle();
        GameProfile profile = new GameProfile(UUID.randomUUID(), state.id);
        ServerPhotographer photographer = new ServerPhotographer(server, world, profile);
        photographer.recorder = new Recorder(photographer, state.option, new File("replay", state.id));
        photographer.saveFile = new File("replay", state.id + ".mcpr");
        photographer.createState = state;
        photographer.recorder.start();
        MinecraftServer.getServer().getPlayerList().placeNewPhotographer(photographer.recorder, photographer, world, state.loc);
        photographer.serverLevel().chunkSource.move(photographer);
        photographer.setInvisible(true);
        photographers.add(photographer);
        LeavesLogger.LOGGER.info("Photographer " + state.id + " created");
        return photographer;
    }

    @Override
    public void tick() {
        super.tick();
        super.doTick();
        if (this.server.getTickCount() % 10 == 0) {
            this.connection.resetPosition();
            this.serverLevel().chunkSource.move(this);
        }
        if (this.followPlayer != null) {
            if (this.getCamera() == this || this.getCamera().level() != this.level()) {
                this.getBukkitPlayer().teleport(this.getCamera().getBukkitEntity().getLocation());
                this.setCamera(this.followPlayer);
            }
            if (this.lastPos.distanceToSqr(this.position()) > 1024.0) {
                this.getBukkitPlayer().teleport(this.getCamera().getBukkitEntity().getLocation());
            }
        }
        this.lastPos = this.position();
    }

    @Override
    public void die(@NotNull DamageSource damageSource) {
        super.die(damageSource);
        this.remove(true);
    }

    @Override
    public boolean isInvulnerableTo(@NotNull DamageSource damageSource) {
        return true;
    }

    @Override
    public boolean hurt(@NotNull DamageSource source, float amount) {
        return false;
    }

    @Override
    public void setHealth(float health) {
    }

    @Override
    @NotNull
    public ServerStatsCounter getStats() {
        return this.stats;
    }

    public void remove(boolean async) {
        this.remove(async, true);
    }

    public void remove(boolean async, boolean save) {
        super.remove(Entity.RemovalReason.KILLED);
        photographers.remove(this);
        this.recorder.stop();
        this.server.getPlayerList().removePhotographer(this);
        LeavesLogger.LOGGER.info("Photographer " + this.createState.id + " removed");
        if (save && !this.recorder.isSaved()) {
            CompletableFuture<Void> future = this.recorder.saveRecording(this.saveFile, save);
            if (!async) {
                future.join();
            }
        }
    }

    public void setFollowPlayer(ServerPlayer followPlayer) {
        this.setCamera(followPlayer);
        this.followPlayer = followPlayer;
    }

    public void setSaveFile(File saveFile) {
        this.saveFile = saveFile;
    }

    public void pauseRecording() {
        this.recorder.pauseRecording();
    }

    public void resumeRecording() {
        this.recorder.resumeRecording();
    }

    public static ServerPhotographer getPhotographer(String id) {
        for (ServerPhotographer photographer : photographers) {
            if (!photographer.createState.id.equals(id)) continue;
            return photographer;
        }
        return null;
    }

    public static ServerPhotographer getPhotographer(UUID uuid) {
        for (ServerPhotographer photographer : photographers) {
            if (!photographer.getUUID().equals(uuid)) continue;
            return photographer;
        }
        return null;
    }

    public static List<ServerPhotographer> getPhotographers() {
        return photographers;
    }

    public Photographer getBukkitPlayer() {
        return this.getBukkitEntity();
    }

    @Override
    @NotNull
    public CraftPhotographer getBukkitEntity() {
        return (CraftPhotographer)super.getBukkitEntity();
    }

    public static class PhotographerCreateState {
        public RecorderOption option;
        public Location loc;
        public final String id;

        public PhotographerCreateState(Location loc, String id, RecorderOption option) {
            this.loc = loc;
            this.id = id;
            this.option = option;
        }

        public ServerPhotographer createSync() {
            try {
                return ServerPhotographer.createPhotographer(this);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

