/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.structs;

import it.unimi.dsi.fastutil.HashCommon;

public class FluidDirectionCache<T> {
    private final FluidDirectionEntry[] entries;
    private final int mask;
    private final int maxDistance;

    public FluidDirectionCache(int size) {
        int arraySize = HashCommon.nextPowerOfTwo((int)size);
        this.entries = new FluidDirectionEntry[arraySize];
        this.mask = arraySize - 1;
        this.maxDistance = Math.min(arraySize, 4);
    }

    public Boolean getValue(T data) {
        int pos = HashCommon.mix((int)data.hashCode()) & this.mask;
        FluidDirectionEntry curr = this.entries[pos];
        if (curr == null) {
            return null;
        }
        if (data.equals(curr.data)) {
            curr.incrementUses();
            return curr.flag;
        }
        int checked = 1;
        while ((curr = this.entries[pos = pos + 1 & this.mask]) != null) {
            if (data.equals(curr.data)) {
                curr.incrementUses();
                return curr.flag;
            }
            if (++checked < this.maxDistance) continue;
            break;
        }
        return null;
    }

    public void putValue(T data, boolean flag) {
        int pos = HashCommon.mix((int)data.hashCode()) & this.mask;
        FluidDirectionEntry curr = this.entries[pos];
        if (curr == null) {
            this.entries[pos] = new FluidDirectionEntry<T>(data, flag);
            return;
        }
        if (data.equals(curr.data)) {
            curr.incrementUses();
            return;
        }
        int checked = 1;
        while ((curr = this.entries[pos = pos + 1 & this.mask]) != null) {
            if (data.equals(curr.data)) {
                curr.incrementUses();
                return;
            }
            if (++checked < this.maxDistance) continue;
            this.forceAdd(data, flag);
            return;
        }
        this.entries[pos] = new FluidDirectionEntry<T>(data, flag);
    }

    private void forceAdd(T data, boolean flag) {
        int expectedPos;
        int toRemovePos = expectedPos = HashCommon.mix((int)data.hashCode()) & this.mask;
        FluidDirectionEntry entryToRemove = this.entries[toRemovePos];
        for (int i = expectedPos + 1; i < expectedPos + this.maxDistance; ++i) {
            int pos = i & this.mask;
            FluidDirectionEntry entry = this.entries[pos];
            if (entry.getValue() < entryToRemove.getValue()) {
                toRemovePos = pos;
                entryToRemove = entry;
            }
            entry.incrementAge();
        }
        this.entries[toRemovePos] = new FluidDirectionEntry<T>(data, flag);
    }

    private static class FluidDirectionEntry<T> {
        private final T data;
        private final boolean flag;
        private int uses = 0;
        private int age = 0;

        private FluidDirectionEntry(T data, boolean flag) {
            this.data = data;
            this.flag = flag;
        }

        public int getValue() {
            return this.uses - (this.age >> 1);
        }

        public void incrementUses() {
            this.uses = this.uses + 1 & Integer.MAX_VALUE;
        }

        public void incrementAge() {
            this.age = this.age + 1 & Integer.MAX_VALUE;
        }
    }
}

