/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.jetbrains.annotations.NotNull;
import org.leavesmc.leaves.LeavesConfig;

public class BreakBedrockList {
    private static final Map<Level, Map<BlockPos, Player>> pistonCache = new HashMap<Level, Map<BlockPos, Player>>();
    private static final List<Objective> BBL = new ArrayList<Objective>();
    private static final List<Objective> MBB = new ArrayList<Objective>();
    private static final List<Objective> LBL = new ArrayList<Objective>();

    public static void endTick() {
        for (Map<BlockPos, Player> map : pistonCache.values()) {
            if (map.isEmpty()) continue;
            map.clear();
        }
    }

    public static void onPlayerPlacePiston(Level level, Player player, BlockPos pos) {
        Direction pistonFacing;
        BlockPos bedrockPos;
        if (LeavesConfig.bedrockBreakList && level.getBlockState(bedrockPos = pos.relative(pistonFacing = level.getBlockState(pos).getValue(DirectionalBlock.FACING))).getBlock() == Blocks.BEDROCK) {
            pistonCache.computeIfAbsent(level, k -> new HashMap()).put(bedrockPos, player);
        }
    }

    public static void onPistonBreakBedrock(Level level, BlockPos bedrock) {
        if (LeavesConfig.bedrockBreakList) {
            Player closestPlayer;
            boolean flag;
            Map<BlockPos, Player> map = pistonCache.get(level);
            boolean bl = flag = map != null && map.get(bedrock) != null;
            if (flag) {
                if (!BBL.isEmpty()) {
                    Player player = map.get(bedrock);
                    for (Objective objective : BBL) {
                        level.getScoreboard().getOrCreatePlayerScore(player, objective).increment();
                    }
                }
            } else if (!MBB.isEmpty()) {
                ScoreHolder world = ScoreHolder.forNameOnly("$" + String.valueOf(level.dimension().location()));
                for (Objective objective : MBB) {
                    level.getScoreboard().getOrCreatePlayerScore(world, objective).increment();
                    level.getScoreboard().getOrCreatePlayerScore(ScoreHolder.forNameOnly("$total"), objective).increment();
                }
            }
            if (!LBL.isEmpty() && !level.players().isEmpty() && (closestPlayer = level.getNearestPlayer((double)bedrock.getX(), (double)bedrock.getY(), (double)bedrock.getZ(), 10.5, null)) != null) {
                for (Objective objective : LBL) {
                    level.getScoreboard().getOrCreatePlayerScore(closestPlayer, objective).increment();
                }
            }
        }
    }

    public static void onScoreboardAdd(@NotNull Objective objective) {
        String name;
        int i;
        if (LeavesConfig.bedrockBreakList && objective.getCriteria() == ObjectiveCriteria.DUMMY && (i = (name = objective.getName()).length() - 4) >= 0) {
            String suffix;
            switch (suffix = name.substring(i)) {
                case ".bbl": {
                    BBL.add(objective);
                    break;
                }
                case ".mbb": {
                    MBB.add(objective);
                    break;
                }
                case ".lbl": {
                    LBL.add(objective);
                }
            }
        }
    }

    public static void onScoreboardRemove(@NotNull Objective objective) {
        String name;
        int i;
        if (LeavesConfig.bedrockBreakList && objective.getCriteria() == ObjectiveCriteria.DUMMY && (i = (name = objective.getName()).length() - 4) >= 0) {
            String suffix;
            switch (suffix = name.substring(i)) {
                case ".bbl": {
                    BBL.remove(objective);
                    break;
                }
                case ".mbb": {
                    MBB.remove(objective);
                    break;
                }
                case ".lbl": {
                    LBL.remove(objective);
                }
            }
        }
    }
}

