/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.util;

import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseCoralPlantTypeBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.CoralClawFeature;
import net.minecraft.world.level.levelgen.feature.CoralFeature;
import net.minecraft.world.level.levelgen.feature.CoralMushroomFeature;
import net.minecraft.world.level.levelgen.feature.CoralTreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;

public interface FertilizableCoral
extends BonemealableBlock {
    public boolean isEnabled();

    @Override
    default public boolean isValidBonemealTarget(@NotNull LevelReader world, @NotNull BlockPos pos, @NotNull BlockState state) {
        return this.isEnabled() && state.getValue(BaseCoralPlantTypeBlock.WATERLOGGED) != false && world.getFluidState(pos.above()).is(FluidTags.WATER);
    }

    @Override
    default public boolean isBonemealSuccess(@NotNull Level world, RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        return (double)random.nextFloat() < 0.15;
    }

    @Override
    default public void performBonemeal(@NotNull ServerLevel worldIn, RandomSource random, @NotNull BlockPos pos, @NotNull BlockState blockUnder) {
        BlockPos randomPos;
        Holder block;
        int variant = random.nextInt(3);
        CoralFeature coral = switch (variant) {
            case 0 -> new CoralClawFeature(NoneFeatureConfiguration.CODEC);
            case 1 -> new CoralTreeFeature(NoneFeatureConfiguration.CODEC);
            default -> new CoralMushroomFeature(NoneFeatureConfiguration.CODEC);
        };
        MapColor color = blockUnder.getMapColor(worldIn, pos);
        BlockState properBlock = blockUnder;
        HolderSet.Named<Block> coralBlocks = worldIn.registryAccess().registryOrThrow(Registries.BLOCK).getTag(BlockTags.CORAL_BLOCKS).orElseThrow();
        Iterator iterator = coralBlocks.iterator();
        while (iterator.hasNext() && (properBlock = ((Block)(block = iterator.next()).value()).defaultBlockState()).getMapColor(worldIn, pos) != color) {
        }
        worldIn.setBlock(pos, Blocks.WATER.defaultBlockState(), 4);
        if (!coral.growSpecific(worldIn, random, pos, properBlock)) {
            worldIn.setBlock(pos, blockUnder, 3);
        } else if (worldIn.random.nextInt(10) == 0 && coralBlocks.contains(worldIn.getBlockState(randomPos = pos.offset(worldIn.random.nextInt(16) - 8, worldIn.random.nextInt(8), worldIn.random.nextInt(16) - 8)).getBlockHolder())) {
            worldIn.setBlock(randomPos, Blocks.WET_SPONGE.defaultBlockState(), 3);
        }
    }
}

