/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.util;

import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HopperCounter {
    private static boolean enabled = false;
    private static final Map<DyeColor, HopperCounter> COUNTERS;
    public final DyeColor color;
    private final TextComponent coloredName;
    private final Object2LongMap<Item> counter = new Object2LongLinkedOpenHashMap();
    private long startTick = -1L;
    private long startMillis;
    private static final Map<Item, Block> DEFAULTS;

    private HopperCounter(DyeColor color) {
        this.color = color;
        this.coloredName = Component.text((String)color.getName(), (TextColor)TextColor.color((int)color.getTextColor()));
    }

    public void add(MinecraftServer server, ItemStack stack) {
        if (this.startTick < 0L) {
            this.startTick = server.overworld().getGameTime();
            this.startMillis = System.currentTimeMillis();
        }
        Item item = stack.getItem();
        this.counter.put((Object)item, this.counter.getLong((Object)item) + (long)stack.getCount());
    }

    public void reset(MinecraftServer server) {
        this.counter.clear();
        this.startTick = server.overworld().getGameTime();
        this.startMillis = System.currentTimeMillis();
    }

    public List<Component> format(MinecraftServer server, boolean realTime) {
        long ticks = Math.max(realTime ? (System.currentTimeMillis() - this.startMillis) / 50L : server.overworld().getGameTime() - this.startTick, -1L);
        if (this.startTick < 0L || ticks == -1L) {
            return Collections.singletonList(((TextComponent.Builder)Component.text().append(new Component[]{this.coloredName, Component.text((String)" hasn't started counting yet")})).build());
        }
        long total = this.getTotalItems();
        if (total <= 0L) {
            return Collections.singletonList(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(new Component[]{Component.text((String)"No items for "), this.coloredName})).append(new Component[]{Component.text((String)" yet ("), Component.text((String)String.format("%.2f ", (double)ticks / 1200.0), (Style)Style.style((TextDecoration)TextDecoration.BOLD))})).append(new Component[]{Component.text((String)"min"), Component.text((String)(realTime ? " - real time" : "")), Component.text((String)")")})).build());
        }
        ArrayList<Component> items = new ArrayList<Component>();
        items.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(new Component[]{Component.text((String)"Items for "), this.coloredName, Component.text((String)" ")})).append(new Component[]{Component.text((String)"("), Component.text((String)String.format("%.2f ", (double)ticks * 1.0 / 1200.0), (Style)Style.style((TextDecoration)TextDecoration.BOLD))})).append(new Component[]{Component.text((String)"min"), Component.text((String)(realTime ? " - real time" : "")), Component.text((String)"), ")})).append(new Component[]{Component.text((String)"total: "), Component.text((long)total, (Style)Style.style((TextDecoration)TextDecoration.BOLD)), Component.text((String)", ")})).append(new Component[]{Component.text((String)"("), Component.text((String)String.format("%.1f", (double)total * 1.0 * 72000.0 / (double)ticks), (Style)Style.style((TextDecoration)TextDecoration.BOLD))})).append((Component)Component.text((String)"/h):"))).build());
        this.counter.object2LongEntrySet().forEach(entry -> {
            Item item = (Item)entry.getKey();
            TranslatableComponent name = Component.translatable((String)item.getDescriptionId());
            TextColor textColor = HopperCounter.guessColor(server, item);
            name = textColor != null ? name.style(name.style().merge(Style.style((TextColor)textColor))) : name.style(name.style().merge(Style.style((TextDecoration)TextDecoration.ITALIC)));
            long count = entry.getLongValue();
            items.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"- ", (TextColor)NamedTextColor.GRAY))).append((Component)name)).append((Component)Component.text((String)": ", (TextColor)NamedTextColor.GRAY))).append(new Component[]{Component.text((long)count, (Style)Style.style((TextDecoration)TextDecoration.BOLD)), Component.text((String)", ", (TextColor)NamedTextColor.GRAY)})).append((Component)Component.text((String)String.format("%.1f", (double)count * 72000.0 / (double)ticks), (Style)Style.style((TextDecoration)TextDecoration.BOLD)))).append((Component)Component.text((String)"/h"))).build());
        });
        return items;
    }

    @Nullable
    public static TextColor guessColor(@NotNull MinecraftServer server, Item item) {
        RegistryAccess.Frozen registryAccess = server.registryAccess();
        TextColor direct = HopperCounter.fromItem(item, registryAccess);
        if (direct != null) {
            return direct;
        }
        ResourceLocation id = registryAccess.registryOrThrow(Registries.ITEM).getKey(item);
        for (RecipeType recipeType : registryAccess.registryOrThrow(Registries.RECIPE_TYPE)) {
            for (Recipe<?> r : HopperCounter.getAllMatching(server.getRecipeManager(), recipeType, id, registryAccess)) {
                for (Ingredient ingredient : r.getIngredients()) {
                    for (Collection<ItemStack> stacks : HopperCounter.getRecipeStacks(ingredient)) {
                        for (ItemStack itemStack : stacks) {
                            TextColor textColor = HopperCounter.fromItem(itemStack.getItem(), registryAccess);
                            if (textColor == null) continue;
                            return textColor;
                        }
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    public static TextColor fromItem(Item item, RegistryAccess registryAccess) {
        if (DEFAULTS.containsKey(item)) {
            return TextColor.color((int)HopperCounter.appropriateColor(HopperCounter.DEFAULTS.get((Object)item).defaultMapColor().col));
        }
        if (item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            return TextColor.color((int)HopperCounter.appropriateColor(dye.getDyeColor().getMapColor().col));
        }
        Block block = null;
        Registry<Item> itemRegistry = registryAccess.registryOrThrow(Registries.ITEM);
        Registry<Block> blockRegistry = registryAccess.registryOrThrow(Registries.BLOCK);
        ResourceLocation id = itemRegistry.getKey(item);
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            block = blockItem.getBlock();
        } else if (blockRegistry.getOptional(id).isPresent()) {
            block = blockRegistry.get(id);
        }
        if (block != null) {
            if (block instanceof AbstractBannerBlock) {
                return TextColor.color((int)HopperCounter.appropriateColor(((AbstractBannerBlock)block).getColor().getMapColor().col));
            }
            if (block instanceof BeaconBeamBlock) {
                return TextColor.color((int)HopperCounter.appropriateColor(((BeaconBeamBlock)((Object)block)).getColor().getMapColor().col));
            }
            return TextColor.color((int)HopperCounter.appropriateColor(block.defaultMapColor().col));
        }
        return null;
    }

    public static List<Recipe<?>> getAllMatching(@NotNull RecipeManager manager, RecipeType<?> type, ResourceLocation output, RegistryAccess registryAccess) {
        Map<ResourceLocation, RecipeHolder<?>> typeRecipes = manager.byName;
        if (typeRecipes == null) {
            return Collections.emptyList();
        }
        if (typeRecipes.containsKey(output)) {
            return Collections.singletonList(typeRecipes.get(output).value());
        }
        Registry<Item> regs = registryAccess.registryOrThrow(Registries.ITEM);
        return typeRecipes.values().stream().filter(r -> Objects.equals(regs.getKey(r.value().getResultItem(registryAccess).getItem()), output)).map(RecipeHolder::value).collect(Collectors.toList());
    }

    public static List<Collection<ItemStack>> getRecipeStacks(@NotNull Ingredient ingredient) {
        return Arrays.stream(ingredient.values).map(Ingredient.Value::getItems).toList();
    }

    public static int appropriateColor(int color) {
        if (color == 0) {
            return MapColor.SNOW.col;
        }
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        if (r < 70) {
            r = 70;
        }
        if (g < 70) {
            g = 70;
        }
        if (b < 70) {
            b = 70;
        }
        return (r << 16) + (g << 8) + b;
    }

    public long getTotalItems() {
        return this.counter.isEmpty() ? 0L : this.counter.values().longStream().sum();
    }

    public static void resetAll(MinecraftServer server, boolean fresh) {
        for (HopperCounter counter : COUNTERS.values()) {
            counter.reset(server);
            if (!fresh) continue;
            counter.startTick = -1L;
        }
    }

    public static HopperCounter getCounter(DyeColor color) {
        return COUNTERS.get(color);
    }

    public static void setEnabled(boolean is) {
        enabled = is;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    static {
        EnumMap<DyeColor, HopperCounter> counterMap = new EnumMap<DyeColor, HopperCounter>(DyeColor.class);
        for (DyeColor color : DyeColor.values()) {
            counterMap.put(color, new HopperCounter(color));
        }
        COUNTERS = Collections.unmodifiableMap(counterMap);
        DEFAULTS = Map.ofEntries(Map.entry(Items.DANDELION, Blocks.YELLOW_WOOL), Map.entry(Items.POPPY, Blocks.RED_WOOL), Map.entry(Items.BLUE_ORCHID, Blocks.LIGHT_BLUE_WOOL), Map.entry(Items.ALLIUM, Blocks.MAGENTA_WOOL), Map.entry(Items.AZURE_BLUET, Blocks.SNOW_BLOCK), Map.entry(Items.RED_TULIP, Blocks.RED_WOOL), Map.entry(Items.ORANGE_TULIP, Blocks.ORANGE_WOOL), Map.entry(Items.WHITE_TULIP, Blocks.SNOW_BLOCK), Map.entry(Items.PINK_TULIP, Blocks.PINK_WOOL), Map.entry(Items.OXEYE_DAISY, Blocks.SNOW_BLOCK), Map.entry(Items.CORNFLOWER, Blocks.BLUE_WOOL), Map.entry(Items.WITHER_ROSE, Blocks.BLACK_WOOL), Map.entry(Items.LILY_OF_THE_VALLEY, Blocks.WHITE_WOOL), Map.entry(Items.BROWN_MUSHROOM, Blocks.BROWN_MUSHROOM_BLOCK), Map.entry(Items.RED_MUSHROOM, Blocks.RED_MUSHROOM_BLOCK), Map.entry(Items.STICK, Blocks.OAK_PLANKS), Map.entry(Items.GOLD_INGOT, Blocks.GOLD_BLOCK), Map.entry(Items.IRON_INGOT, Blocks.IRON_BLOCK), Map.entry(Items.DIAMOND, Blocks.DIAMOND_BLOCK), Map.entry(Items.NETHERITE_INGOT, Blocks.NETHERITE_BLOCK), Map.entry(Items.SUNFLOWER, Blocks.YELLOW_WOOL), Map.entry(Items.LILAC, Blocks.MAGENTA_WOOL), Map.entry(Items.ROSE_BUSH, Blocks.RED_WOOL), Map.entry(Items.PEONY, Blocks.PINK_WOOL), Map.entry(Items.CARROT, Blocks.ORANGE_WOOL), Map.entry(Items.APPLE, Blocks.RED_WOOL), Map.entry(Items.WHEAT, Blocks.HAY_BLOCK), Map.entry(Items.PORKCHOP, Blocks.PINK_WOOL), Map.entry(Items.RABBIT, Blocks.PINK_WOOL), Map.entry(Items.CHICKEN, Blocks.WHITE_TERRACOTTA), Map.entry(Items.BEEF, Blocks.NETHERRACK), Map.entry(Items.ENCHANTED_GOLDEN_APPLE, Blocks.GOLD_BLOCK), Map.entry(Items.COD, Blocks.WHITE_TERRACOTTA), Map.entry(Items.SALMON, Blocks.ACACIA_PLANKS), Map.entry(Items.ROTTEN_FLESH, Blocks.BROWN_WOOL), Map.entry(Items.PUFFERFISH, Blocks.YELLOW_TERRACOTTA), Map.entry(Items.TROPICAL_FISH, Blocks.ORANGE_WOOL), Map.entry(Items.POTATO, Blocks.WHITE_TERRACOTTA), Map.entry(Items.MUTTON, Blocks.RED_WOOL), Map.entry(Items.BEETROOT, Blocks.NETHERRACK), Map.entry(Items.MELON_SLICE, Blocks.MELON), Map.entry(Items.POISONOUS_POTATO, Blocks.SLIME_BLOCK), Map.entry(Items.SPIDER_EYE, Blocks.NETHERRACK), Map.entry(Items.GUNPOWDER, Blocks.GRAY_WOOL), Map.entry(Items.TURTLE_SCUTE, Blocks.LIME_WOOL), Map.entry(Items.FEATHER, Blocks.WHITE_WOOL), Map.entry(Items.FLINT, Blocks.BLACK_WOOL), Map.entry(Items.LEATHER, Blocks.SPRUCE_PLANKS), Map.entry(Items.GLOWSTONE_DUST, Blocks.GLOWSTONE), Map.entry(Items.PAPER, Blocks.WHITE_WOOL), Map.entry(Items.BRICK, Blocks.BRICKS), Map.entry(Items.INK_SAC, Blocks.BLACK_WOOL), Map.entry(Items.SNOWBALL, Blocks.SNOW_BLOCK), Map.entry(Items.WATER_BUCKET, Blocks.WATER), Map.entry(Items.LAVA_BUCKET, Blocks.LAVA), Map.entry(Items.MILK_BUCKET, Blocks.WHITE_WOOL), Map.entry(Items.CLAY_BALL, Blocks.CLAY), Map.entry(Items.COCOA_BEANS, Blocks.COCOA), Map.entry(Items.BONE, Blocks.BONE_BLOCK), Map.entry(Items.COD_BUCKET, Blocks.BROWN_TERRACOTTA), Map.entry(Items.PUFFERFISH_BUCKET, Blocks.YELLOW_TERRACOTTA), Map.entry(Items.SALMON_BUCKET, Blocks.PINK_TERRACOTTA), Map.entry(Items.TROPICAL_FISH_BUCKET, Blocks.ORANGE_TERRACOTTA), Map.entry(Items.SUGAR, Blocks.WHITE_WOOL), Map.entry(Items.BLAZE_POWDER, Blocks.GOLD_BLOCK), Map.entry(Items.ENDER_PEARL, Blocks.WARPED_PLANKS), Map.entry(Items.NETHER_STAR, Blocks.DIAMOND_BLOCK), Map.entry(Items.PRISMARINE_CRYSTALS, Blocks.SEA_LANTERN), Map.entry(Items.PRISMARINE_SHARD, Blocks.PRISMARINE), Map.entry(Items.RABBIT_HIDE, Blocks.OAK_PLANKS), Map.entry(Items.CHORUS_FRUIT, Blocks.PURPUR_BLOCK), Map.entry(Items.SHULKER_SHELL, Blocks.SHULKER_BOX), Map.entry(Items.NAUTILUS_SHELL, Blocks.BONE_BLOCK), Map.entry(Items.HEART_OF_THE_SEA, Blocks.CONDUIT), Map.entry(Items.HONEYCOMB, Blocks.HONEYCOMB_BLOCK), Map.entry(Items.NAME_TAG, Blocks.BONE_BLOCK), Map.entry(Items.TOTEM_OF_UNDYING, Blocks.YELLOW_TERRACOTTA), Map.entry(Items.TRIDENT, Blocks.PRISMARINE), Map.entry(Items.GHAST_TEAR, Blocks.WHITE_WOOL), Map.entry(Items.PHANTOM_MEMBRANE, Blocks.BONE_BLOCK), Map.entry(Items.EGG, Blocks.BONE_BLOCK), Map.entry(Items.COPPER_INGOT, Blocks.COPPER_BLOCK), Map.entry(Items.AMETHYST_SHARD, Blocks.AMETHYST_BLOCK));
    }
}

